/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.producer;

import com.taobao.common.store.Store;
import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.client.MetaClientConfig;
import com.taobao.metamorphosis.client.extension.producer.LocalMessageStorageManager;
import com.taobao.metamorphosis.client.extension.producer.MessageRecoverManager;
import com.taobao.metamorphosis.client.extension.storage.MessageStore;
import com.taobao.metamorphosis.cluster.Partition;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;

public class OrderedLocalMessageStorageManager
extends LocalMessageStorageManager {
    public OrderedLocalMessageStorageManager(MetaClientConfig metaClientConfig) {
        super(metaClientConfig);
    }

    @Override
    public void recover() {
        Set names = this.topicStoreMap.keySet();
        if (names == null || names.size() == 0) {
            log.info((Object)"SendRecover\u6ca1\u6709\u9700\u8981\u6062\u590d\u7684\u6d88\u606f");
            return;
        }
        if (this.messageRecoverer != null) {
            for (String name : names) {
                String[] tmps = name.split("@");
                String topic = tmps[0];
                Partition partition = new Partition(tmps[1]);
                if (partition.equals((Object)Partition.RandomPartiton) || this.getMessageCount(topic, partition) <= 0) continue;
                this.recover(topic, partition, this.messageRecoverer);
            }
        } else {
            log.warn((Object)"messageRecoverer\u8fd8\u672a\u8bbe\u7f6e");
        }
    }

    @Override
    public boolean recover(final String topic, final Partition partition, final MessageRecoverManager.MessageRecoverer recoverer) {
        FutureTask<Boolean> recoverTask;
        final String name = this.generateKey(topic, partition);
        FutureTask<Boolean> ret = this.topicRecoverTaskMap.putIfAbsent(name, recoverTask = new FutureTask<Boolean>(new Callable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean call() throws Exception {
                try {
                    int count = 0;
                    Store randomPartitonStore = OrderedLocalMessageStorageManager.this.getOrCreateStore(topic, Partition.RandomPartiton);
                    if (randomPartitonStore.size() > 0) {
                        Store store = randomPartitonStore;
                        synchronized (store) {
                            if (randomPartitonStore.size() > 0) {
                                count = this.innerRecover(randomPartitonStore, recoverer);
                                LocalMessageStorageManager.log.info((Object)("SendRecover topic=" + topic + "@-1--1\u6062\u590d\u6d88\u606f" + count + "\u6761"));
                            }
                        }
                    }
                    Store store = OrderedLocalMessageStorageManager.this.getOrCreateStore(topic, partition);
                    count = this.innerRecover(store, recoverer);
                    LocalMessageStorageManager.log.info((Object)("SendRecover topic=" + name + "\u6062\u590d\u6d88\u606f" + count + "\u6761"));
                }
                catch (Throwable e) {
                    LocalMessageStorageManager.log.error((Object)("SendRecover\u53d1\u9001\u6d88\u606f\u6062\u590d\u5931\u8d25,topic=" + name), e);
                }
                finally {
                    LocalMessageStorageManager.log.info((Object)("SendRecover\u6267\u884c\u5b8c\u6bd5\u79fb\u9664\u53d1\u9001\u6062\u590d\u4efb\u52a1,topic=" + name));
                    OrderedLocalMessageStorageManager.this.topicRecoverTaskMap.remove(name);
                }
                return true;
            }

            private int innerRecover(Store store, MessageRecoverManager.MessageRecoverer recoverer2) throws IOException, Exception {
                Iterator it = store.iterator();
                int count = 0;
                while (it.hasNext()) {
                    byte[] key = (byte[])it.next();
                    Message msg = (Message)OrderedLocalMessageStorageManager.this.deserializer.decodeObject(store.get(key));
                    recoverer2.handle(msg);
                    try {
                        store.remove(key);
                        ++count;
                    }
                    catch (IOException e) {
                        LocalMessageStorageManager.log.error((Object)"SendRecover remove message failed", (Throwable)e);
                    }
                }
                return count;
            }
        }));
        if (ret == null) {
            this.threadPoolExecutor.submit(recoverTask);
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("SendRecover\u53d1\u9001\u6062\u590d\u4efb\u52a1\u6b63\u5728\u8fd0\u884c,\u4e0d\u9700\u8981\u91cd\u65b0\u542f\u52a8,topic=" + topic));
        }
        return false;
    }

    @Override
    protected Store newStore(String name) throws IOException {
        return new MessageStore(this.META_LOCALMESSAGE_PATH + File.separator + name, name);
    }
}

