/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.producer;

import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.client.extension.producer.AvailablePartitionNumException;
import com.taobao.metamorphosis.client.extension.producer.ConfigPartitionsSupport;
import com.taobao.metamorphosis.cluster.Partition;
import com.taobao.metamorphosis.exception.MetaClientException;
import java.util.List;

public abstract class OrderedMessagePartitionSelector
extends ConfigPartitionsSupport {
    @Override
    public Partition getPartition(String topic, List<Partition> partitions, Message message) throws MetaClientException {
        int availablePartitionNum = partitions != null ? partitions.size() : 0;
        List<Partition> configPartitions = this.getConfigPartitions(topic);
        int configPartitionsNum = configPartitions.size();
        if (configPartitionsNum == 0) {
            throw new MetaClientException("There is no config partitions for topic " + topic + ",maybe you don't config it at first?");
        }
        Partition selectedPartition = this.choosePartition(topic, configPartitions, message);
        if (selectedPartition == null) {
            throw new MetaClientException("selected null partition");
        }
        if (availablePartitionNum == 0) {
            throw new AvailablePartitionNumException("selected partition[" + selectedPartition + "]for topic[" + topic + "]can not write now");
        }
        if (!configPartitions.contains(selectedPartition) && !partitions.contains(selectedPartition)) {
            throw new MetaClientException("invalid selected partition:" + selectedPartition + ",config and availabe paritions not contains it");
        }
        if (configPartitions.contains(selectedPartition) && partitions.contains(selectedPartition)) {
            return selectedPartition;
        }
        throw new AvailablePartitionNumException("selected partition[" + selectedPartition + "]for topic[" + topic + "]can not write now");
    }

    protected abstract Partition choosePartition(String var1, List<Partition> var2, Message var3);
}

