/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.producer;

import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

class SlidingWindow {
    private final Semaphore semaphore;
    private final ItemUnit itemUnit;
    private final int itemUnitSize;

    SlidingWindow(int itemUnitSize) {
        this(itemUnitSize, new DefaultItemUnit());
    }

    SlidingWindow(int itemUnitSize, ItemUnit itemUnit) {
        this.itemUnitSize = itemUnitSize;
        this.semaphore = new Semaphore(this.itemUnitSize);
        this.itemUnit = itemUnit;
    }

    public boolean tryAcquireByLength(int lenth) {
        return this.semaphore.tryAcquire(this.covertToItemLength(lenth));
    }

    public boolean tryAcquireByLength(int length, long timeout, TimeUnit unit) throws InterruptedException {
        return this.semaphore.tryAcquire(this.covertToItemLength(length), timeout, unit);
    }

    public void releaseByLenth(int length) {
        this.semaphore.release(this.covertToItemLength(length));
    }

    public int getWindowsSize() {
        return this.itemUnitSize;
    }

    private int covertToItemLength(int length) {
        return this.itemUnit.covertToItemLength(length);
    }

    static class DefaultItemUnit
    implements ItemUnit {
        DefaultItemUnit() {
        }

        @Override
        public int covertToItemLength(int length) {
            int i = length / 4096;
            return i > 0 ? i : 1;
        }
    }

    static interface ItemUnit {
        public int covertToItemLength(int var1);
    }
}

