/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.spring;

import com.taobao.gecko.core.util.StringUtils;
import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.client.extension.spring.MessageBodyConverter;
import com.taobao.metamorphosis.exception.MetaClientException;

public class MessageBuilder {
    private final String topic;
    private String attribute;
    private Object body;
    private byte[] payload;

    private MessageBuilder(String topic) {
        if (StringUtils.isBlank((String)topic)) {
            throw new IllegalArgumentException("blank topic");
        }
        this.topic = topic;
    }

    public static final MessageBuilder withTopic(String topic) {
        return new MessageBuilder(topic);
    }

    public final MessageBuilder withAttribute(String attr) {
        this.attribute = attr;
        return this;
    }

    public final MessageBuilder withBody(Object obj) {
        if (this.payload != null) {
            throw new IllegalArgumentException("Payload is exists.");
        }
        this.body = obj;
        return this;
    }

    public final MessageBuilder withPayload(byte[] payload) {
        if (this.body != null) {
            throw new IllegalArgumentException("Message body is exists.");
        }
        this.payload = payload;
        return this;
    }

    public Message build() {
        return this.build(null);
    }

    public <T> Message build(MessageBodyConverter<T> converter) {
        if (StringUtils.isBlank((String)this.topic)) {
            throw new IllegalArgumentException("Blank topic");
        }
        if (this.body == null && this.payload == null) {
            throw new IllegalArgumentException("Empty payload");
        }
        byte[] payload = this.payload;
        if (payload == null && converter != null) {
            try {
                payload = converter.toByteArray(this.body);
            }
            catch (MetaClientException e) {
                throw new IllegalStateException("Convert message body failed.", e);
            }
        }
        if (payload == null) {
            throw new IllegalArgumentException("Empty payload");
        }
        return new Message(this.topic, payload, this.attribute);
    }
}

