/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.extension.spring;

import com.taobao.gecko.core.util.StringUtils;
import com.taobao.metamorphosis.Message;
import com.taobao.metamorphosis.client.MessageSessionFactory;
import com.taobao.metamorphosis.client.extension.spring.MessageBodyConverter;
import com.taobao.metamorphosis.client.extension.spring.MessageBuilder;
import com.taobao.metamorphosis.client.producer.MessageProducer;
import com.taobao.metamorphosis.client.producer.SendMessageCallback;
import com.taobao.metamorphosis.client.producer.SendResult;
import com.taobao.metamorphosis.exception.MetaClientException;
import com.taobao.metamorphosis.utils.ThreadUtils;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.springframework.beans.factory.DisposableBean;

public class MetaqTemplate
implements DisposableBean {
    private MessageSessionFactory messageSessionFactory;
    private String defaultTopic;
    private MessageBodyConverter<?> messageBodyConverter;
    private boolean shareProducer = false;
    private volatile MessageProducer sharedProducer;
    private final ConcurrentHashMap<String, FutureTask<MessageProducer>> producers = new ConcurrentHashMap();

    public boolean isShareProducer() {
        return this.shareProducer;
    }

    public void setShareProducer(boolean producerPerTopic) {
        this.shareProducer = producerPerTopic;
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    public MessageBodyConverter<?> getMessageBodyConverter() {
        return this.messageBodyConverter;
    }

    public void setMessageBodyConverter(MessageBodyConverter<?> messageBodyConverter) {
        if (messageBodyConverter == null) {
            throw new IllegalArgumentException("Null messageBodyConverter");
        }
        this.messageBodyConverter = messageBodyConverter;
    }

    public void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public MessageSessionFactory getMessageSessionFactory() {
        return this.messageSessionFactory;
    }

    public void setMessageSessionFactory(MessageSessionFactory messageSessionFactory) {
        if (messageSessionFactory == null) {
            throw new IllegalArgumentException("Null messageSessionFactory");
        }
        this.messageSessionFactory = messageSessionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MessageProducer getOrCreateProducer(final String topic) {
        if (!this.shareProducer) {
            FutureTask<MessageProducer> task = this.producers.get(topic);
            if (task == null) {
                task = new FutureTask<MessageProducer>(new Callable<MessageProducer>(){

                    @Override
                    public MessageProducer call() throws Exception {
                        MessageProducer producer = MetaqTemplate.this.messageSessionFactory.createProducer();
                        producer.publish(topic);
                        if (!StringUtils.isBlank((String)MetaqTemplate.this.defaultTopic)) {
                            producer.setDefaultTopic(MetaqTemplate.this.defaultTopic);
                        }
                        return producer;
                    }
                });
                FutureTask<MessageProducer> oldTask = this.producers.putIfAbsent(topic, task);
                if (oldTask != null) {
                    task = oldTask;
                } else {
                    task.run();
                }
            }
            try {
                MessageProducer producer = task.get();
                return producer;
            }
            catch (ExecutionException e) {
                throw ThreadUtils.launderThrowable((Throwable)e.getCause());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        } else {
            if (this.sharedProducer == null) {
                MetaqTemplate metaqTemplate = this;
                synchronized (metaqTemplate) {
                    if (this.sharedProducer == null) {
                        this.sharedProducer = this.messageSessionFactory.createProducer();
                        if (!StringUtils.isBlank((String)this.defaultTopic)) {
                            this.sharedProducer.setDefaultTopic(this.defaultTopic);
                        }
                    }
                }
            }
            this.sharedProducer.publish(topic);
            return this.sharedProducer;
        }
        throw new IllegalStateException("Could not create producer for topic '" + topic + "'");
    }

    public SendResult send(MessageBuilder builder, long timeout, TimeUnit unit) throws InterruptedException {
        Message msg = builder.build(this.messageBodyConverter);
        String topic = msg.getTopic();
        MessageProducer producer = this.getOrCreateProducer(topic);
        try {
            return producer.sendMessage(msg, timeout, unit);
        }
        catch (MetaClientException e) {
            return new SendResult(false, null, -1L, ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public SendResult send(MessageBuilder builder) throws InterruptedException {
        Message msg = builder.build(this.messageBodyConverter);
        String topic = msg.getTopic();
        MessageProducer producer = this.getOrCreateProducer(topic);
        try {
            return producer.sendMessage(msg);
        }
        catch (MetaClientException e) {
            return new SendResult(false, null, -1L, ExceptionUtils.getFullStackTrace((Throwable)e));
        }
    }

    public void send(MessageBuilder builder, SendMessageCallback cb, long timeout, TimeUnit unit) {
        Message msg = builder.build(this.messageBodyConverter);
        String topic = msg.getTopic();
        MessageProducer producer = this.getOrCreateProducer(topic);
        producer.sendMessage(msg, cb, timeout, unit);
    }

    public void destroy() throws Exception {
        if (this.sharedProducer != null) {
            this.sharedProducer.shutdown();
            this.sharedProducer = null;
        }
        for (FutureTask<MessageProducer> task : this.producers.values()) {
            try {
                MessageProducer producer = task.get(5000L, TimeUnit.MILLISECONDS);
                if (producer == null) continue;
                producer.shutdown();
            }
            catch (Exception exception) {}
        }
        this.producers.clear();
    }

    public void send(MessageBuilder builder, SendMessageCallback cb) {
        Message msg = builder.build(this.messageBodyConverter);
        String topic = msg.getTopic();
        MessageProducer producer = this.getOrCreateProducer(topic);
        producer.sendMessage(msg, cb);
    }
}

