/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.producer;

import com.taobao.gecko.core.util.ConcurrentHashSet;
import com.taobao.metamorphosis.client.MetaMessageSessionFactory;
import com.taobao.metamorphosis.client.RemotingClientWrapper;
import com.taobao.metamorphosis.client.producer.PartitionSelector;
import com.taobao.metamorphosis.client.producer.ProducerZooKeeper;
import com.taobao.metamorphosis.client.producer.SimpleMessageProducer;
import com.taobao.metamorphosis.client.producer.XAMessageProducer;
import com.taobao.metamorphosis.client.transaction.TransactionContext;
import com.taobao.metamorphosis.exception.InvalidBrokerException;
import com.taobao.metamorphosis.exception.MetaClientException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.transaction.xa.XAResource;
import org.apache.commons.lang.StringUtils;

public class SimpleXAMessageProducer
extends SimpleMessageProducer
implements XAMessageProducer,
ProducerZooKeeper.BrokerChangeListener {
    private String uniqueQualifier = "XAMessageProducer-" + SimpleXAMessageProducer.getLocalhostName();
    private static final String OVERWRITE_HOSTNAME_SYSTEM_PROPERTY = "metaq.client.xaproducer.hostname";
    final Set<String> publishedTopics = new ConcurrentHashSet();
    private final Random rand = new Random();
    private volatile String[] urls;

    public static String getLocalhostName() {
        String property = System.getProperty(OVERWRITE_HOSTNAME_SYSTEM_PROPERTY);
        if (property != null && property.trim().length() > 0) {
            return property;
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("unable to retrieve localhost name");
        }
    }

    public SimpleXAMessageProducer(MetaMessageSessionFactory messageSessionFactory, RemotingClientWrapper remotingClient, PartitionSelector partitionSelector, ProducerZooKeeper producerZooKeeper, String sessionId) {
        super(messageSessionFactory, remotingClient, partitionSelector, producerZooKeeper, sessionId);
    }

    @Override
    public void publish(String topic) {
        super.publish(topic);
        if (this.publishedTopics.add(topic)) {
            this.generateTransactionBrokerURLs();
        }
    }

    @Override
    public void brokersChanged(String topic) {
        this.generateTransactionBrokerURLs();
    }

    private void generateTransactionBrokerURLs() {
        ArrayList brokerUrls = new ArrayList();
        for (String topic : this.publishedTopics) {
            brokerUrls.add(this.producerZooKeeper.getServerUrlSetByTopic(topic));
            this.producerZooKeeper.onBrokerChange(topic, this);
        }
        Set<String> resultSet = SimpleXAMessageProducer.intersect(brokerUrls);
        if (resultSet.isEmpty()) {
            throw new InvalidBrokerException("Could not select a common broker url for  topics:" + this.publishedTopics);
        }
        Object[] newUrls = resultSet.toArray(new String[resultSet.size()]);
        Arrays.sort(newUrls);
        this.urls = newUrls;
    }

    private String selectTransactionBrokerURL() {
        String[] copiedUrls = this.urls;
        if (copiedUrls == null || copiedUrls.length == 0) {
            throw new InvalidBrokerException("Could not select a common broker url for  topics:" + this.publishedTopics);
        }
        return copiedUrls[this.rand.nextInt(copiedUrls.length)];
    }

    static <T> Set<T> intersect(List<Set<T>> sets) {
        if (sets == null || sets.size() == 0) {
            return null;
        }
        Set<T> rt = sets.get(0);
        for (int i = 1; i < sets.size(); ++i) {
            HashSet<T> copy = new HashSet<T>(rt);
            copy.retainAll((Collection)sets.get(i));
            rt = copy;
        }
        return rt;
    }

    @Override
    public String getUniqueQualifier() {
        return this.uniqueQualifier;
    }

    @Override
    public void setUniqueQualifier(String uniqueQualifier) {
        this.checkUniqueQualifier(this.uniqueQualifier);
        this.uniqueQualifier = uniqueQualifier;
    }

    @Override
    public void setUniqueQualifierPrefix(String prefix) {
        this.checkUniqueQualifier(prefix);
        this.uniqueQualifier = prefix + "-" + SimpleXAMessageProducer.getLocalhostName();
    }

    private void checkUniqueQualifier(String prefix) {
        if (StringUtils.isBlank((String)prefix)) {
            throw new IllegalArgumentException("Blank unique qualifier for SimpleXAMessageProducer");
        }
        if (StringUtils.containsAny((String)prefix, (String)"\r\n\t: ")) {
            throw new IllegalArgumentException("Invalid unique qualifier,it should not contains newline,':' or blank characters.");
        }
    }

    @Override
    public XAResource getXAResource() throws MetaClientException {
        TransactionContext xares = (TransactionContext)this.transactionContext.get();
        if (xares != null) {
            return xares;
        }
        this.beginTransaction();
        xares = (TransactionContext)this.transactionContext.get();
        String selectedServer = this.selectTransactionBrokerURL();
        xares.setServerUrl(selectedServer);
        xares.setUniqueQualifier(this.uniqueQualifier);
        xares.setXareresourceURLs(this.urls);
        this.logLastSentInfo(selectedServer);
        return xares;
    }

    @Override
    public synchronized void shutdown() throws MetaClientException {
        for (String topic : this.publishedTopics) {
            this.producerZooKeeper.deregisterBrokerChangeListener(topic, this);
        }
        super.shutdown();
    }
}

