/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.metamorphosis.client.transaction;

import com.taobao.gecko.core.command.RequestCommand;
import com.taobao.gecko.core.command.ResponseCommand;
import com.taobao.gecko.core.command.ResponseStatus;
import com.taobao.gecko.core.util.OpaqueGenerator;
import com.taobao.gecko.service.Connection;
import com.taobao.gecko.service.RemotingClient;
import com.taobao.gecko.service.SingleRequestCallBackListener;
import com.taobao.metamorphosis.client.transaction.TransactionSession;
import com.taobao.metamorphosis.exception.MetaClientException;
import com.taobao.metamorphosis.exception.TransactionInProgressException;
import com.taobao.metamorphosis.network.BooleanCommand;
import com.taobao.metamorphosis.network.TransactionCommand;
import com.taobao.metamorphosis.transaction.LocalTransactionId;
import com.taobao.metamorphosis.transaction.TransactionId;
import com.taobao.metamorphosis.transaction.TransactionInfo;
import com.taobao.metamorphosis.transaction.XATransactionId;
import com.taobao.metamorphosis.utils.LongSequenceGenerator;
import com.taobao.metamorphosis.utils.MetaStatLog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TransactionContext
implements XAResource {
    public static final EndXATransactionListener END_XA_TX_LISTENER = new EndXATransactionListener();
    public static final Log log = LogFactory.getLog(TransactionContext.class);
    private final RemotingClient remotingClient;
    private Xid associatedXid;
    private String serverUrl;
    private TransactionId transactionId;
    private final String sessionId;
    private final LongSequenceGenerator localTransactionIdGenerator;
    private int transactionTimeout;
    private static final Log LOG = LogFactory.getLog(TransactionContext.class);
    private final TransactionSession associatedSession;
    private final long startMs;
    private String uniqueQualifier;
    private String[] xareresourceURLs;
    private final long transactionRequestTimeoutInMills;
    static final Pattern NEW_LINE_PATTERN = Pattern.compile("\r\n");
    static final Xid[] EMPTY_IDS = new Xid[0];
    static Pattern EXCEPTION_PAT = Pattern.compile("code=(-?\\d+),msg=(.*)");

    public String[] getXareresourceURLs() {
        return this.xareresourceURLs;
    }

    public void setXareresourceURLs(String[] xareresourceURLs) {
        this.xareresourceURLs = xareresourceURLs;
    }

    public String getUniqueQualifier() {
        return this.uniqueQualifier;
    }

    public void setUniqueQualifier(String uniqueQualifier) {
        this.uniqueQualifier = uniqueQualifier;
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    public TransactionContext(RemotingClient remotingClient, String serverUrl, TransactionSession session, LongSequenceGenerator localTransactionIdGenerator, int transactionTimeout, long transactionRequestTimeoutInMills) {
        this.remotingClient = remotingClient;
        this.serverUrl = serverUrl;
        this.localTransactionIdGenerator = localTransactionIdGenerator;
        this.associatedSession = session;
        this.sessionId = session.getSessionId();
        this.transactionTimeout = transactionTimeout;
        this.transactionRequestTimeoutInMills = transactionRequestTimeoutInMills;
        this.startMs = System.currentTimeMillis();
    }

    private void logTxTime() {
        long value = System.currentTimeMillis() - this.startMs;
        MetaStatLog.addStatValue2(null, (String)"txExecTime", (long)value);
    }

    public boolean isInXATransaction() {
        return this.transactionId != null && this.transactionId.isXATransaction();
    }

    public boolean isInLocalTransaction() {
        return this.transactionId != null && this.transactionId.isLocalTransaction();
    }

    public boolean isInTransaction() {
        return this.transactionId != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Commit: " + xid));
        }
        if (xid == null || this.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        XATransactionId x = new XATransactionId(xid, this.uniqueQualifier);
        MetaStatLog.addStat(null, (String)"txCommit");
        this.checkConnectionConnected();
        try {
            TransactionInfo info = new TransactionInfo((TransactionId)x, this.sessionId, onePhase ? TransactionInfo.TransactionType.COMMIT_ONE_PHASE : TransactionInfo.TransactionType.COMMIT_TWO_PHASE, this.uniqueQualifier);
            this.syncSendXATxCommand(info);
        }
        finally {
            this.associatedSession.removeContext(this);
            this.logTxTime();
        }
    }

    private void checkConnectionConnected() throws XAException {
        if (!this.remotingClient.isConnected(this.serverUrl)) {
            throw new XAException(-7);
        }
    }

    private boolean equals(Xid xid1, Xid xid2) {
        if (xid1 == xid2) {
            return true;
        }
        if (xid1 == null || xid2 == null) {
            return false;
        }
        return xid1.getFormatId() == xid2.getFormatId() && Arrays.equals(xid1.getBranchQualifier(), xid2.getBranchQualifier()) && Arrays.equals(xid1.getGlobalTransactionId(), xid2.getGlobalTransactionId());
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End: " + xid));
        }
        if (this.isInLocalTransaction()) {
            throw new XAException(-6);
        }
        if ((flags & 0x22000000) != 0) {
            if (!this.equals(this.associatedXid, xid)) {
                throw new XAException(-6);
            }
            this.setXid(null);
        } else if ((flags & 0x4000000) == 0x4000000) {
            if (this.equals(this.associatedXid, xid)) {
                this.setXid(null);
            }
        } else {
            throw new XAException(-5);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Forget: " + xid));
        }
        if (xid == null) {
            throw new XAException(-6);
        }
        XATransactionId x = this.equals(this.associatedXid, xid) ? (XATransactionId)this.transactionId : new XATransactionId(xid, this.uniqueQualifier);
        TransactionInfo info = new TransactionInfo((TransactionId)x, this.sessionId, TransactionInfo.TransactionType.FORGET, this.uniqueQualifier);
        this.syncSendXATxCommand(info);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.transactionTimeout;
    }

    private String getResourceManagerId() {
        return this.serverUrl;
    }

    @Override
    public boolean isSameRM(XAResource xaResource) throws XAException {
        if (xaResource == null) {
            return false;
        }
        if (!(xaResource instanceof TransactionContext)) {
            return false;
        }
        TransactionContext xar = (TransactionContext)xaResource;
        try {
            return this.getResourceManagerId().equals(xar.getResourceManagerId());
        }
        catch (Throwable e) {
            throw (XAException)new XAException("Could not get resource manager id.").initCause(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Prepare: " + xid));
        }
        if (xid == null || this.equals(this.associatedXid, xid)) {
            throw new XAException(-6);
        }
        XATransactionId x = new XATransactionId(xid, this.uniqueQualifier);
        MetaStatLog.addStat(null, (String)"txPrepare");
        TransactionInfo info = new TransactionInfo((TransactionId)x, this.sessionId, TransactionInfo.TransactionType.PREPARE, this.uniqueQualifier);
        BooleanCommand response = this.syncSendXATxCommand(info);
        int result = Integer.parseInt(response.getErrorMsg());
        if (3 == result && LOG.isDebugEnabled()) {
            LOG.debug((Object)("XA_RDONLY from prepare: " + xid));
        }
        return result;
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Recover with flag: " + flag));
        }
        TransactionInfo info = new TransactionInfo(null, this.sessionId, TransactionInfo.TransactionType.RECOVER, this.uniqueQualifier);
        try {
            ArrayList<XATransactionId> xidList = new ArrayList<XATransactionId>();
            if (this.xareresourceURLs == null || this.xareresourceURLs.length == 0) {
                throw new XAException(-7);
            }
            for (String serverUrl : this.xareresourceURLs) {
                try {
                    String[] xidStrs;
                    BooleanCommand receipt = (BooleanCommand)this.remotingClient.invokeToGroup(serverUrl, (RequestCommand)new TransactionCommand(info, Integer.valueOf(OpaqueGenerator.getNextOpaque())), this.transactionRequestTimeoutInMills, TimeUnit.MILLISECONDS);
                    if (receipt.getCode() != 200) {
                        log.warn((Object)("Recover XAResource(" + serverUrl + ") failed,error message:" + receipt.getErrorMsg()));
                        continue;
                    }
                    String data = receipt.getErrorMsg();
                    if (StringUtils.isBlank((String)data)) continue;
                    for (String key : xidStrs = NEW_LINE_PATTERN.split(data)) {
                        if (StringUtils.isBlank((String)key)) continue;
                        xidList.add(new XATransactionId(key));
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw this.toXAException(e);
                }
                catch (Exception e) {
                    log.error((Object)("Recover XAResource(" + serverUrl + ") faile"), (Throwable)e);
                }
            }
            if (xidList.isEmpty()) {
                return EMPTY_IDS;
            }
            Xid[] rt = new Xid[xidList.size()];
            return xidList.toArray(rt);
        }
        catch (Exception e) {
            throw this.toXAException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rollback(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rollback: " + xid));
        }
        if (xid == null) {
            throw new XAException(-6);
        }
        XATransactionId x = this.equals(this.associatedXid, xid) ? (XATransactionId)this.transactionId : new XATransactionId(xid, this.uniqueQualifier);
        MetaStatLog.addStat(null, (String)"txRollback");
        this.checkConnectionConnected();
        try {
            TransactionInfo info = new TransactionInfo((TransactionId)x, this.sessionId, TransactionInfo.TransactionType.ROLLBACK, this.uniqueQualifier);
            this.syncSendXATxCommand(info);
        }
        finally {
            this.associatedSession.removeContext(this);
            this.logTxTime();
        }
    }

    private BooleanCommand syncSendXATxCommand(TransactionInfo info) throws XAException {
        try {
            BooleanCommand resp = (BooleanCommand)this.remotingClient.invokeToGroup(this.serverUrl, (RequestCommand)new TransactionCommand(info, Integer.valueOf(OpaqueGenerator.getNextOpaque())), this.transactionRequestTimeoutInMills, TimeUnit.MILLISECONDS);
            if (resp.getResponseStatus() != ResponseStatus.NO_ERROR) {
                String msg = resp.getErrorMsg();
                if (msg.startsWith("XAException:")) {
                    Matcher m = EXCEPTION_PAT.matcher(msg);
                    if (m.find()) {
                        int code = Integer.parseInt(m.group(1));
                        String error = m.group(2);
                        XAException xaException = new XAException(error);
                        xaException.errorCode = code;
                        throw xaException;
                    }
                    this.throwRMFailException(resp);
                } else {
                    this.throwRMFailException(resp);
                }
            }
            return resp;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.toXAException(e);
        }
        catch (Exception e) {
            throw this.toXAException(e);
        }
    }

    private void throwRMFailException(BooleanCommand resp) throws XAException {
        XAException xaException = new XAException(resp.getErrorMsg());
        xaException.errorCode = -3;
        throw xaException;
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        if (seconds < 0) {
            throw new XAException(-5);
        }
        this.transactionTimeout = seconds;
        return true;
    }

    XAException toXAException(Exception e) {
        if (e instanceof TimeoutException) {
            XAException xae = new XAException(e.getMessage());
            xae.errorCode = 106;
            xae.initCause(e);
            return xae;
        }
        if (e.getCause() != null && e.getCause() instanceof XAException) {
            XAException original = (XAException)e.getCause();
            XAException xae = new XAException(original.getMessage());
            xae.errorCode = original.errorCode;
            xae.initCause(original);
            return xae;
        }
        if (e instanceof XAException) {
            return (XAException)e;
        }
        XAException xae = new XAException(e.getMessage());
        xae.errorCode = -7;
        xae.initCause(e);
        return xae;
    }

    private void setXid(Xid xid) throws XAException {
        this.checkConnectionConnected();
        if (xid != null) {
            this.startXATransaction(xid);
        } else {
            this.endXATransaction();
        }
    }

    private void endXATransaction() throws XAException {
        if (this.transactionId != null) {
            MetaStatLog.addStat(null, (String)"txEnd");
            TransactionInfo info = new TransactionInfo(this.transactionId, this.sessionId, TransactionInfo.TransactionType.END, this.uniqueQualifier);
            try {
                this.remotingClient.sendToGroup(this.serverUrl, (RequestCommand)new TransactionCommand(info, Integer.valueOf(OpaqueGenerator.getNextOpaque())), (SingleRequestCallBackListener)END_XA_TX_LISTENER, this.transactionRequestTimeoutInMills, TimeUnit.MILLISECONDS);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Ended XA transaction: " + this.transactionId));
                }
            }
            catch (Exception e) {
                throw this.toXAException(e);
            }
        }
        this.associatedXid = null;
        this.transactionId = null;
    }

    private void startXATransaction(Xid xid) throws XAException {
        MetaStatLog.addStat(null, (String)"txBegin");
        this.associatedXid = xid;
        this.transactionId = new XATransactionId(xid, this.uniqueQualifier);
        TransactionInfo info = new TransactionInfo(this.transactionId, this.sessionId, TransactionInfo.TransactionType.BEGIN, this.uniqueQualifier, this.transactionTimeout);
        this.syncSendXATxCommand(info);
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start: " + xid));
        }
        if (!((flags & 0x200000) != 0x200000 && (flags & 0x8000000) != 0x8000000 || this.equals(this.associatedXid, xid))) {
            throw new XAException(-4);
        }
        if (this.isInLocalTransaction()) {
            throw new XAException(-6);
        }
        if (this.associatedXid != null) {
            throw new XAException(-8);
        }
        this.setXid(xid);
    }

    public void begin() throws MetaClientException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot start local transaction.  XA transaction is already in progress.");
        }
        if (this.transactionId == null) {
            MetaStatLog.addStat(null, (String)"txBegin");
            this.transactionId = new LocalTransactionId(this.sessionId, this.localTransactionIdGenerator.getNextSequenceId());
            TransactionInfo info = new TransactionInfo(this.transactionId, this.sessionId, TransactionInfo.TransactionType.BEGIN, this.uniqueQualifier, this.transactionTimeout);
            try {
                this.checkConnectionConnected();
                this.syncSendLocalTxCommand(info);
            }
            catch (Exception e) {
                throw this.toMetaClientException(e);
            }
        }
    }

    private MetaClientException toMetaClientException(Exception e) {
        if (e instanceof MetaClientException) {
            return (MetaClientException)((Object)e);
        }
        if (e instanceof XAException) {
            return new MetaClientException(e.getMessage(), e.getCause() != null ? e.getCause() : e);
        }
        return new MetaClientException((Throwable)e);
    }

    public void commit() throws MetaClientException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot commit() if an XA transaction is already in progress ");
        }
        if (this.transactionId != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Commit: " + this.transactionId));
            }
            MetaStatLog.addStat(null, (String)"txCommit");
            try {
                TransactionInfo info = new TransactionInfo(this.transactionId, this.sessionId, TransactionInfo.TransactionType.COMMIT_ONE_PHASE, this.uniqueQualifier);
                this.transactionId = null;
                this.syncSendLocalTxCommand(info);
            }
            catch (TimeoutException e) {
                throw new MetaClientException("Commit transaction timeout,the transaction state is unknown,you must check it by yourself.", (Throwable)e);
            }
            finally {
                this.logTxTime();
            }
        } else {
            throw new MetaClientException("No transaction is started");
        }
    }

    public String toString() {
        return this.serverUrl;
    }

    private void syncSendLocalTxCommand(TransactionInfo info) throws MetaClientException, TimeoutException {
        try {
            BooleanCommand resp = (BooleanCommand)this.remotingClient.invokeToGroup(this.serverUrl, (RequestCommand)new TransactionCommand(info, Integer.valueOf(OpaqueGenerator.getNextOpaque())), this.transactionRequestTimeoutInMills, TimeUnit.MILLISECONDS);
            if (resp.getResponseStatus() != ResponseStatus.NO_ERROR) {
                throw new MetaClientException(resp.getErrorMsg());
            }
        }
        catch (TimeoutException te) {
            throw te;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw this.toMetaClientException(e);
        }
        catch (Exception e) {
            throw this.toMetaClientException(e);
        }
    }

    public void rollback() throws MetaClientException {
        if (this.isInXATransaction()) {
            throw new TransactionInProgressException("Cannot rollback() if an XA transaction is already in progress ");
        }
        if (this.transactionId != null) {
            MetaStatLog.addStat(null, (String)"txRollback");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Rollback: " + this.transactionId));
            }
            try {
                TransactionInfo info = new TransactionInfo(this.transactionId, this.sessionId, TransactionInfo.TransactionType.ROLLBACK, this.uniqueQualifier);
                this.transactionId = null;
                this.syncSendLocalTxCommand(info);
            }
            catch (TimeoutException e) {
                throw new MetaClientException("Rollback transaction timeout,the transaction state is unknown,you must check it by yourself.", (Throwable)e);
            }
            finally {
                this.logTxTime();
            }
        } else {
            throw new MetaClientException("No transaction is started");
        }
    }

    private static final class EndXATransactionListener
    implements SingleRequestCallBackListener {
        private EndXATransactionListener() {
        }

        public void onResponse(ResponseCommand responseCommand, Connection conn) {
        }

        public void onException(Exception e) {
            log.warn((Object)("End xa transaction failed:" + e.getMessage()));
        }

        public ThreadPoolExecutor getExecutor() {
            return null;
        }
    }
}

