/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt;

import com.unfbx.chatgpt.entity.billing.CreditGrantsResponse;
import com.unfbx.chatgpt.entity.chat.ChatCompletion;
import com.unfbx.chatgpt.entity.chat.ChatCompletionResponse;
import com.unfbx.chatgpt.entity.common.DeleteResponse;
import com.unfbx.chatgpt.entity.common.OpenAiResponse;
import com.unfbx.chatgpt.entity.completions.Completion;
import com.unfbx.chatgpt.entity.completions.CompletionResponse;
import com.unfbx.chatgpt.entity.edits.Edit;
import com.unfbx.chatgpt.entity.edits.EditResponse;
import com.unfbx.chatgpt.entity.embeddings.Embedding;
import com.unfbx.chatgpt.entity.embeddings.EmbeddingResponse;
import com.unfbx.chatgpt.entity.engines.Engine;
import com.unfbx.chatgpt.entity.files.File;
import com.unfbx.chatgpt.entity.files.UploadFileResponse;
import com.unfbx.chatgpt.entity.fineTune.Event;
import com.unfbx.chatgpt.entity.fineTune.FineTune;
import com.unfbx.chatgpt.entity.fineTune.FineTuneResponse;
import com.unfbx.chatgpt.entity.images.Image;
import com.unfbx.chatgpt.entity.images.ImageResponse;
import com.unfbx.chatgpt.entity.models.Model;
import com.unfbx.chatgpt.entity.models.ModelResponse;
import com.unfbx.chatgpt.entity.moderations.Moderation;
import com.unfbx.chatgpt.entity.moderations.ModerationResponse;
import com.unfbx.chatgpt.entity.whisper.WhisperResponse;
import io.reactivex.Single;
import java.util.Map;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.Multipart;
import retrofit2.http.POST;
import retrofit2.http.Part;
import retrofit2.http.PartMap;
import retrofit2.http.Path;
import retrofit2.http.Streaming;

public interface OpenAiApi {
    @GET(value="v1/models")
    public Single<ModelResponse> models();

    @GET(value="v1/models/{id}")
    public Single<Model> model(@Path(value="id") String var1);

    @POST(value="v1/completions")
    public Single<CompletionResponse> completions(@Body Completion var1);

    @POST(value="v1/edits")
    public Single<EditResponse> edits(@Body Edit var1);

    @POST(value="v1/images/generations")
    public Single<ImageResponse> genImages(@Body Image var1);

    @Multipart
    @POST(value="v1/images/edits")
    public Single<ImageResponse> editImages(@Part MultipartBody.Part var1, @Part MultipartBody.Part var2, @PartMap Map<String, RequestBody> var3);

    @Multipart
    @POST(value="v1/images/variations")
    public Single<ImageResponse> variationsImages(@Part MultipartBody.Part var1, @PartMap Map<String, RequestBody> var2);

    @POST(value="v1/embeddings")
    public Single<EmbeddingResponse> embeddings(@Body Embedding var1);

    @GET(value="/v1/files")
    public Single<OpenAiResponse<File>> files();

    @DELETE(value="v1/files/{file_id}")
    public Single<DeleteResponse> deleteFile(@Path(value="file_id") String var1);

    @Multipart
    @POST(value="v1/files")
    public Single<UploadFileResponse> uploadFile(@Part MultipartBody.Part var1, @Part(value="purpose") RequestBody var2);

    @GET(value="v1/files/{file_id}")
    public Single<File> retrieveFile(@Path(value="file_id") String var1);

    @Streaming
    @GET(value="v1/files/{file_id}/content")
    public Single<ResponseBody> retrieveFileContent(@Path(value="file_id") String var1);

    @POST(value="v1/moderations")
    public Single<ModerationResponse> moderations(@Body Moderation var1);

    @POST(value="v1/fine-tunes")
    public Single<FineTuneResponse> fineTune(@Body FineTune var1);

    @GET(value="v1/fine-tunes")
    public Single<OpenAiResponse<FineTuneResponse>> fineTunes();

    @GET(value="v1/fine-tunes/{fine_tune_id}")
    public Single<FineTuneResponse> retrieveFineTune(@Path(value="fine_tune_id") String var1);

    @POST(value="v1/fine-tunes/{fine_tune_id}/cancel")
    public Single<FineTuneResponse> cancelFineTune(@Path(value="fine_tune_id") String var1);

    @GET(value="v1/fine-tunes/{fine_tune_id}/events")
    public Single<OpenAiResponse<Event>> fineTuneEvents(@Path(value="fine_tune_id") String var1);

    @GET(value="v1/models/{model}")
    public Single<DeleteResponse> deleteFineTuneModel(@Path(value="model") String var1);

    @Deprecated
    @GET(value="v1/engines")
    public Single<OpenAiResponse<Engine>> engines();

    @Deprecated
    @GET(value="v1/engines/{engine_id}")
    public Single<Engine> engine(@Path(value="engine_id") String var1);

    @POST(value="v1/chat/completions")
    public Single<ChatCompletionResponse> chatCompletion(@Body ChatCompletion var1);

    @Multipart
    @POST(value="v1/audio/transcriptions")
    public Single<WhisperResponse> speechToTextTranscriptions(@Part MultipartBody.Part var1, @Part(value="model") RequestBody var2);

    @Multipart
    @POST(value="v1/audio/translations")
    public Single<WhisperResponse> speechToTextTranslations(@Part MultipartBody.Part var1, @Part(value="model") RequestBody var2);

    @GET(value="dashboard/billing/credit_grants")
    public Single<CreditGrantsResponse> creditGrants();
}

