/*
 * Decompiled with CFR 0.152.
 */
package com.unfbx.chatgpt.entity.moderations;

import com.unfbx.chatgpt.exception.BaseException;
import com.unfbx.chatgpt.exception.CommonError;
import java.io.Serializable;
import java.util.Objects;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Moderation
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Moderation.class);
    @NonNull
    private String input;
    private String model;

    public void setInput(String input) {
        if (Objects.isNull(input) || "".equals(input)) {
            log.error("input\u4e0d\u80fd\u4e3a\u7a7a");
            throw new BaseException(CommonError.PARAM_ERROR);
        }
        this.input = input;
    }

    public void setModel(Model model) {
        if (Objects.isNull((Object)model)) {
            model = Model.TEXT_MODERATION_LATEST;
        }
        this.model = model.getName();
    }

    private static String $default$model() {
        return Model.TEXT_MODERATION_LATEST.getName();
    }

    public static ModerationBuilder builder() {
        return new ModerationBuilder();
    }

    @NonNull
    public String getInput() {
        return this.input;
    }

    public String getModel() {
        return this.model;
    }

    public Moderation() {
        this.model = Moderation.$default$model();
    }

    public Moderation(@NonNull String input, String model) {
        if (input == null) {
            throw new NullPointerException("input is marked non-null but is null");
        }
        this.input = input;
        this.model = model;
    }

    public static class ModerationBuilder {
        private String input;
        private boolean model$set;
        private String model$value;

        ModerationBuilder() {
        }

        public ModerationBuilder input(@NonNull String input) {
            if (input == null) {
                throw new NullPointerException("input is marked non-null but is null");
            }
            this.input = input;
            return this;
        }

        public ModerationBuilder model(String model) {
            this.model$value = model;
            this.model$set = true;
            return this;
        }

        public Moderation build() {
            String model$value = this.model$value;
            if (!this.model$set) {
                model$value = Moderation.$default$model();
            }
            return new Moderation(this.input, model$value);
        }

        public String toString() {
            return "Moderation.ModerationBuilder(input=" + this.input + ", model$value=" + this.model$value + ")";
        }
    }

    public static enum Model {
        TEXT_MODERATION_STABLE("text-moderation-stable"),
        TEXT_MODERATION_LATEST("text-moderation-latest");

        private String name;

        public String getName() {
            return this.name;
        }

        private Model(String name) {
            this.name = name;
        }
    }
}

