/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.schema;

import io.debezium.relational.Column;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.types.DataType;

public class MySqlTypeUtils {
    private static final String BIT = "BIT";
    private static final String TINYINT = "TINYINT";
    private static final String TINYINT_UNSIGNED = "TINYINT UNSIGNED";
    private static final String SMALLINT = "SMALLINT";
    private static final String SMALLINT_UNSIGNED = "SMALLINT UNSIGNED";
    private static final String MEDIUMINT = "MEDIUMINT";
    private static final String MEDIUMINT_UNSIGNED = "MEDIUMINT UNSIGNED";
    private static final String INT = "INT";
    private static final String INT_UNSIGNED = "INT UNSIGNED";
    private static final String BIGINT = "BIGINT";
    private static final String BIGINT_UNSIGNED = "BIGINT UNSIGNED";
    private static final String FLOAT = "FLOAT";
    private static final String FLOAT_UNSIGNED = "FLOAT UNSIGNED";
    private static final String DOUBLE = "DOUBLE";
    private static final String DOUBLE_UNSIGNED = "DOUBLE UNSIGNED";
    private static final String DECIMAL = "DECIMAL";
    private static final String DECIMAL_UNSIGNED = "DECIMAL UNSIGNED";
    private static final String CHAR = "CHAR";
    private static final String VARCHAR = "VARCHAR";
    private static final String TINYTEXT = "TINYTEXT";
    private static final String MEDIUMTEXT = "MEDIUMTEXT";
    private static final String TEXT = "TEXT";
    private static final String LONGTEXT = "LONGTEXT";
    private static final String DATE = "DATE";
    private static final String TIME = "TIME";
    private static final String DATETIME = "DATETIME";
    private static final String TIMESTAMP = "TIMESTAMP";
    private static final String YEAR = "YEAR";
    private static final String BINARY = "BINARY";
    private static final String VARBINARY = "VARBINARY";
    private static final String TINYBLOB = "TINYBLOB";
    private static final String MEDIUMBLOB = "MEDIUMBLOB";
    private static final String BLOB = "BLOB";
    private static final String LONGBLOB = "LONGBLOB";
    private static final String JSON = "JSON";
    private static final String SET = "SET";
    private static final String ENUM = "ENUM";
    private static final String GEOMETRY = "GEOMETRY";
    private static final String UNKNOWN = "UNKNOWN";

    public static DataType fromDbzColumn(Column column) {
        DataType dataType = MySqlTypeUtils.convertFromColumn(column);
        if (column.isOptional()) {
            return dataType;
        }
        return (DataType)dataType.notNull();
    }

    private static DataType convertFromColumn(Column column) {
        String typeName;
        switch (typeName = column.typeName()) {
            case "TINYINT": {
                return column.length() == 1 ? DataTypes.BOOLEAN() : DataTypes.TINYINT();
            }
            case "TINYINT UNSIGNED": 
            case "SMALLINT": {
                return DataTypes.SMALLINT();
            }
            case "SMALLINT UNSIGNED": 
            case "INT": 
            case "MEDIUMINT": {
                return DataTypes.INT();
            }
            case "INT UNSIGNED": 
            case "MEDIUMINT UNSIGNED": 
            case "BIGINT": {
                return DataTypes.BIGINT();
            }
            case "BIGINT UNSIGNED": {
                return DataTypes.DECIMAL((int)20, (int)0);
            }
            case "FLOAT": {
                return DataTypes.FLOAT();
            }
            case "DOUBLE": {
                return DataTypes.DOUBLE();
            }
            case "DECIMAL": {
                return DataTypes.DECIMAL((int)column.length(), (int)column.scale().orElse(0));
            }
            case "TIME": {
                return column.length() >= 0 ? DataTypes.TIME((int)column.length()) : DataTypes.TIME();
            }
            case "DATE": {
                return DataTypes.DATE();
            }
            case "DATETIME": 
            case "TIMESTAMP": {
                return column.length() >= 0 ? DataTypes.TIMESTAMP((int)column.length()) : DataTypes.TIMESTAMP();
            }
            case "CHAR": {
                return DataTypes.CHAR((int)column.length());
            }
            case "VARCHAR": {
                return DataTypes.VARCHAR((int)column.length());
            }
            case "TEXT": {
                return DataTypes.STRING();
            }
            case "BINARY": {
                return DataTypes.BINARY((int)column.length());
            }
            case "VARBINARY": {
                return DataTypes.VARBINARY((int)column.length());
            }
            case "BLOB": {
                return DataTypes.BYTES();
            }
        }
        throw new UnsupportedOperationException(String.format("Don't support MySQL type '%s' yet.", typeName));
    }
}

