/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.source.reader;

import com.github.shyiko.mysql.binlog.BinaryLogClient;
import com.ververica.cdc.connectors.mysql.debezium.DebeziumUtils;
import com.ververica.cdc.connectors.mysql.debezium.reader.BinlogSplitReader;
import com.ververica.cdc.connectors.mysql.debezium.reader.DebeziumReader;
import com.ververica.cdc.connectors.mysql.debezium.reader.SnapshotSplitReader;
import com.ververica.cdc.connectors.mysql.debezium.task.context.StatefulTaskContext;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceConfig;
import com.ververica.cdc.connectors.mysql.source.split.MySqlRecords;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import io.debezium.connector.mysql.MySqlConnection;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import javax.annotation.Nullable;
import org.apache.flink.connector.base.source.reader.RecordsWithSplitIds;
import org.apache.flink.connector.base.source.reader.splitreader.SplitReader;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsAddition;
import org.apache.flink.connector.base.source.reader.splitreader.SplitsChange;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlSplitReader
implements SplitReader<SourceRecord, MySqlSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlSplitReader.class);
    private final Queue<MySqlSplit> splits;
    private final MySqlSourceConfig sourceConfig;
    private final int subtaskId;
    @Nullable
    private DebeziumReader<SourceRecord, MySqlSplit> currentReader;
    @Nullable
    private String currentSplitId;

    public MySqlSplitReader(MySqlSourceConfig sourceConfig, int subtaskId) {
        this.sourceConfig = sourceConfig;
        this.subtaskId = subtaskId;
        this.splits = new ArrayDeque<MySqlSplit>();
    }

    public RecordsWithSplitIds<SourceRecord> fetch() throws IOException {
        this.checkSplitOrStartNext();
        Iterator<SourceRecord> dataIt = null;
        try {
            dataIt = this.currentReader.pollSplitRecords();
        }
        catch (InterruptedException e) {
            LOG.warn("fetch data failed.", (Throwable)e);
            throw new IOException(e);
        }
        return dataIt == null ? this.finishedSnapshotSplit() : MySqlRecords.forRecords(this.currentSplitId, dataIt);
    }

    public void handleSplitsChanges(SplitsChange<MySqlSplit> splitsChanges) {
        if (!(splitsChanges instanceof SplitsAddition)) {
            throw new UnsupportedOperationException(String.format("The SplitChange type of %s is not supported.", splitsChanges.getClass()));
        }
        LOG.debug("Handling split change {}", splitsChanges);
        this.splits.addAll(splitsChanges.splits());
    }

    public void wakeUp() {
    }

    public void close() throws Exception {
        if (this.currentReader != null) {
            LOG.info("Close current debezium reader {}", (Object)this.currentReader.getClass().getCanonicalName());
            this.currentReader.close();
            this.currentSplitId = null;
        }
    }

    private void checkSplitOrStartNext() throws IOException {
        if (this.currentReader instanceof BinlogSplitReader) {
            return;
        }
        if (this.canAssignNextSplit()) {
            MySqlSplit nextSplit = this.splits.poll();
            if (nextSplit == null) {
                throw new IOException("Cannot fetch from another split - no split remaining");
            }
            this.currentSplitId = nextSplit.splitId();
            if (nextSplit.isSnapshotSplit()) {
                if (this.currentReader == null) {
                    MySqlConnection jdbcConnection = DebeziumUtils.createMySqlConnection(this.sourceConfig.getDbzConfiguration());
                    BinaryLogClient binaryLogClient = DebeziumUtils.createBinaryClient(this.sourceConfig.getDbzConfiguration());
                    StatefulTaskContext statefulTaskContext = new StatefulTaskContext(this.sourceConfig, binaryLogClient, jdbcConnection);
                    this.currentReader = new SnapshotSplitReader(statefulTaskContext, this.subtaskId);
                }
            } else {
                if (this.currentReader != null) {
                    LOG.info("It's turn to read binlog split, close current snapshot reader");
                    this.currentReader.close();
                }
                MySqlConnection jdbcConnection = DebeziumUtils.createMySqlConnection(this.sourceConfig.getDbzConfiguration());
                BinaryLogClient binaryLogClient = DebeziumUtils.createBinaryClient(this.sourceConfig.getDbzConfiguration());
                StatefulTaskContext statefulTaskContext = new StatefulTaskContext(this.sourceConfig, binaryLogClient, jdbcConnection);
                this.currentReader = new BinlogSplitReader(statefulTaskContext, this.subtaskId);
                LOG.info("BinlogSplitReader is created.");
            }
            this.currentReader.submitSplit(nextSplit);
        }
    }

    private boolean canAssignNextSplit() {
        return this.currentReader == null || this.currentReader.isFinished();
    }

    private MySqlRecords finishedSnapshotSplit() {
        MySqlRecords finishedRecords = MySqlRecords.forFinishedSplit(this.currentSplitId);
        this.currentSplitId = null;
        return finishedRecords;
    }
}

