/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.mysql.debezium.reader;

import com.ververica.cdc.connectors.mysql.debezium.dispatcher.SignalEventDispatcher;
import com.ververica.cdc.connectors.mysql.debezium.reader.DebeziumReader;
import com.ververica.cdc.connectors.mysql.debezium.task.MySqlBinlogSplitReadTask;
import com.ververica.cdc.connectors.mysql.debezium.task.MySqlSnapshotSplitReadTask;
import com.ververica.cdc.connectors.mysql.debezium.task.context.StatefulTaskContext;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.split.FinishedSnapshotSplitInfo;
import com.ververica.cdc.connectors.mysql.source.split.MySqlBinlogSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSnapshotSplit;
import com.ververica.cdc.connectors.mysql.source.split.MySqlSplit;
import com.ververica.cdc.connectors.mysql.source.split.SourceRecords;
import com.ververica.cdc.connectors.mysql.source.utils.RecordUtils;
import io.debezium.config.Configuration;
import io.debezium.connector.base.ChangeEventQueue;
import io.debezium.connector.mysql.MySqlConnectorConfig;
import io.debezium.connector.mysql.MySqlOffsetContext;
import io.debezium.connector.mysql.MySqlStreamingChangeEventSourceMetrics;
import io.debezium.heartbeat.Heartbeat;
import io.debezium.pipeline.DataChangeEvent;
import io.debezium.pipeline.source.spi.ChangeEventSource;
import io.debezium.pipeline.spi.SnapshotResult;
import io.debezium.util.SchemaNameAdjuster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.shaded.guava30.com.google.common.util.concurrent.ThreadFactoryBuilder;
import org.apache.flink.util.FlinkRuntimeException;
import org.apache.flink.util.Preconditions;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotSplitReader
implements DebeziumReader<SourceRecords, MySqlSplit> {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotSplitReader.class);
    private final StatefulTaskContext statefulTaskContext;
    private final ExecutorService executorService;
    private volatile ChangeEventQueue<DataChangeEvent> queue;
    private volatile boolean currentTaskRunning;
    private volatile Throwable readException;
    private MySqlSnapshotSplitReadTask splitSnapshotReadTask;
    private MySqlSnapshotSplit currentSnapshotSplit;
    private SchemaNameAdjuster nameAdjuster;
    public AtomicBoolean hasNextElement;
    public AtomicBoolean reachEnd;
    private static final long READER_CLOSE_TIMEOUT = 30L;

    public SnapshotSplitReader(StatefulTaskContext statefulTaskContext, int subtaskId) {
        this.statefulTaskContext = statefulTaskContext;
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat("debezium-reader-" + subtaskId).setUncaughtExceptionHandler((thread, throwable) -> this.setReadException(throwable)).build();
        this.executorService = Executors.newSingleThreadExecutor(threadFactory);
        this.currentTaskRunning = false;
        this.hasNextElement = new AtomicBoolean(false);
        this.reachEnd = new AtomicBoolean(false);
    }

    @Override
    public void submitSplit(MySqlSplit mySqlSplit) {
        this.currentSnapshotSplit = mySqlSplit.asSnapshotSplit();
        this.statefulTaskContext.configure(this.currentSnapshotSplit);
        this.queue = this.statefulTaskContext.getQueue();
        this.nameAdjuster = this.statefulTaskContext.getSchemaNameAdjuster();
        this.hasNextElement.set(true);
        this.reachEnd.set(false);
        this.splitSnapshotReadTask = new MySqlSnapshotSplitReadTask(this.statefulTaskContext.getConnectorConfig(), this.statefulTaskContext.getSnapshotChangeEventSourceMetrics(), this.statefulTaskContext.getDatabaseSchema(), this.statefulTaskContext.getConnection(), this.statefulTaskContext.getDispatcher(), this.statefulTaskContext.getTopicSelector(), this.statefulTaskContext.getSnapshotReceiver(), StatefulTaskContext.getClock(), this.currentSnapshotSplit);
        this.executorService.execute(() -> {
            try {
                this.currentTaskRunning = true;
                SnapshotSplitChangeEventSourceContextImpl sourceContext = new SnapshotSplitChangeEventSourceContextImpl();
                SnapshotResult<MySqlOffsetContext> snapshotResult = this.splitSnapshotReadTask.execute((ChangeEventSource.ChangeEventSourceContext)sourceContext, this.statefulTaskContext.getMySqlPartition(), this.statefulTaskContext.getOffsetContext());
                MySqlBinlogSplit backfillBinlogSplit = this.createBackfillBinlogSplit(sourceContext);
                boolean binlogBackfillRequired = backfillBinlogSplit.getEndingOffset().isAfter(backfillBinlogSplit.getStartingOffset());
                if (!binlogBackfillRequired) {
                    this.dispatchBinlogEndEvent(backfillBinlogSplit);
                    this.currentTaskRunning = false;
                    return;
                }
                if (snapshotResult.isCompletedOrSkipped()) {
                    MySqlBinlogSplitReadTask backfillBinlogReadTask = this.createBackfillBinlogReadTask(backfillBinlogSplit);
                    MySqlOffsetContext.Loader loader = new MySqlOffsetContext.Loader(this.statefulTaskContext.getConnectorConfig());
                    MySqlOffsetContext mySqlOffsetContext = loader.load(backfillBinlogSplit.getStartingOffset().getOffset());
                    backfillBinlogReadTask.execute((ChangeEventSource.ChangeEventSourceContext)new SnapshotBinlogSplitChangeEventSourceContextImpl(), this.statefulTaskContext.getMySqlPartition(), mySqlOffsetContext);
                } else {
                    this.setReadException(new IllegalStateException(String.format("Read snapshot for mysql split %s fail", this.currentSnapshotSplit)));
                }
            }
            catch (Exception e) {
                this.setReadException(e);
            }
        });
    }

    private MySqlBinlogSplit createBackfillBinlogSplit(SnapshotSplitChangeEventSourceContextImpl sourceContext) {
        return new MySqlBinlogSplit(this.currentSnapshotSplit.splitId(), sourceContext.getLowWatermark(), sourceContext.getHighWatermark(), new ArrayList<FinishedSnapshotSplitInfo>(), this.currentSnapshotSplit.getTableSchemas(), 0);
    }

    private MySqlBinlogSplitReadTask createBackfillBinlogReadTask(MySqlBinlogSplit backfillBinlogSplit) {
        Configuration dezConf = ((Configuration.Builder)this.statefulTaskContext.getSourceConfig().getDbzConfiguration().edit().with("table.include.list", this.currentSnapshotSplit.getTableId().toString()).with(Heartbeat.HEARTBEAT_INTERVAL, 0)).build();
        return new MySqlBinlogSplitReadTask(new MySqlConnectorConfig(dezConf), this.statefulTaskContext.getConnection(), this.statefulTaskContext.getDispatcher(), this.statefulTaskContext.getSignalEventDispatcher(), this.statefulTaskContext.getErrorHandler(), StatefulTaskContext.getClock(), this.statefulTaskContext.getTaskContext(), (MySqlStreamingChangeEventSourceMetrics)this.statefulTaskContext.getStreamingChangeEventSourceMetrics(), backfillBinlogSplit, event -> true);
    }

    private void dispatchBinlogEndEvent(MySqlBinlogSplit backFillBinlogSplit) throws InterruptedException {
        SignalEventDispatcher signalEventDispatcher = new SignalEventDispatcher(this.statefulTaskContext.getOffsetContext().getOffset(), this.statefulTaskContext.getTopicSelector().getPrimaryTopic(), this.statefulTaskContext.getDispatcher().getQueue());
        signalEventDispatcher.dispatchWatermarkEvent(backFillBinlogSplit, backFillBinlogSplit.getEndingOffset(), SignalEventDispatcher.WatermarkKind.BINLOG_END);
    }

    @Override
    public boolean isFinished() {
        return this.currentSnapshotSplit == null || !this.currentTaskRunning && !this.hasNextElement.get() && this.reachEnd.get();
    }

    @Override
    @Nullable
    public Iterator<SourceRecords> pollSplitRecords() throws InterruptedException {
        this.checkReadException();
        if (this.hasNextElement.get()) {
            boolean reachBinlogStart = false;
            boolean reachBinlogEnd = false;
            SourceRecord lowWatermark = null;
            SourceRecord highWatermark = null;
            HashMap<Struct, List<SourceRecord>> snapshotRecords = new HashMap<Struct, List<SourceRecord>>();
            block0: while (!reachBinlogEnd) {
                this.checkReadException();
                List batch = this.queue.poll();
                for (DataChangeEvent event : batch) {
                    SourceRecord record = event.getRecord();
                    if (lowWatermark == null) {
                        lowWatermark = record;
                        this.assertLowWatermark(lowWatermark);
                        continue;
                    }
                    if (highWatermark == null && RecordUtils.isHighWatermarkEvent(record)) {
                        highWatermark = record;
                        reachBinlogStart = true;
                        continue;
                    }
                    if (reachBinlogStart && RecordUtils.isEndWatermarkEvent(record)) {
                        reachBinlogEnd = true;
                        continue block0;
                    }
                    if (!reachBinlogStart) {
                        if (record.key() != null) {
                            snapshotRecords.put((Struct)record.key(), Collections.singletonList(record));
                            continue;
                        }
                        List records = snapshotRecords.computeIfAbsent((Struct)record.value(), key -> new LinkedList());
                        records.add(record);
                        continue;
                    }
                    RecordUtils.upsertBinlog(snapshotRecords, record, this.currentSnapshotSplit.getSplitKeyType(), this.nameAdjuster, this.currentSnapshotSplit.getSplitStart(), this.currentSnapshotSplit.getSplitEnd());
                }
            }
            this.hasNextElement.set(false);
            ArrayList<SourceRecord> normalizedRecords = new ArrayList<SourceRecord>();
            normalizedRecords.add(lowWatermark);
            normalizedRecords.addAll(RecordUtils.formatMessageTimestamp(snapshotRecords.values().stream().flatMap(Collection::stream).collect(Collectors.toList())));
            normalizedRecords.add(highWatermark);
            ArrayList<SourceRecords> sourceRecordsSet = new ArrayList<SourceRecords>();
            sourceRecordsSet.add(new SourceRecords(normalizedRecords));
            return sourceRecordsSet.iterator();
        }
        this.reachEnd.compareAndSet(false, true);
        return null;
    }

    private void checkReadException() {
        if (this.readException != null) {
            throw new FlinkRuntimeException(String.format("Read split %s error due to %s.", this.currentSnapshotSplit, this.readException.getMessage()), this.readException);
        }
    }

    private void assertLowWatermark(SourceRecord lowWatermark) {
        Preconditions.checkState((boolean)RecordUtils.isLowWatermarkEvent(lowWatermark), (Object)String.format("The first record should be low watermark signal event, but actual is %s", lowWatermark));
    }

    private void setReadException(Throwable throwable) {
        this.currentTaskRunning = false;
        LOG.error(String.format("Execute snapshot read task for mysql split %s fail", this.currentSnapshotSplit), throwable);
        if (this.readException == null) {
            this.readException = throwable;
        } else {
            this.readException.addSuppressed(throwable);
        }
    }

    @Override
    public void close() {
        try {
            if (this.statefulTaskContext.getConnection() != null) {
                this.statefulTaskContext.getConnection().close();
            }
            if (this.statefulTaskContext.getBinaryLogClient() != null) {
                this.statefulTaskContext.getBinaryLogClient().disconnect();
            }
            if (this.statefulTaskContext.getDatabaseSchema() != null) {
                this.statefulTaskContext.getDatabaseSchema().close();
            }
            if (this.executorService != null) {
                this.executorService.shutdown();
                if (!this.executorService.awaitTermination(30L, TimeUnit.SECONDS)) {
                    LOG.warn("Failed to close the snapshot split reader in {} seconds.", (Object)30L);
                }
            }
        }
        catch (Exception e) {
            LOG.error("Close snapshot reader error", (Throwable)e);
        }
    }

    @VisibleForTesting
    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public class SnapshotBinlogSplitChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        public void finished() {
            SnapshotSplitReader.this.currentTaskRunning = false;
        }

        public boolean isRunning() {
            return SnapshotSplitReader.this.currentTaskRunning;
        }
    }

    public static class SnapshotSplitChangeEventSourceContextImpl
    implements ChangeEventSource.ChangeEventSourceContext {
        private BinlogOffset lowWatermark;
        private BinlogOffset highWatermark;

        public BinlogOffset getLowWatermark() {
            return this.lowWatermark;
        }

        public void setLowWatermark(BinlogOffset lowWatermark) {
            this.lowWatermark = lowWatermark;
        }

        public BinlogOffset getHighWatermark() {
            return this.highWatermark;
        }

        public void setHighWatermark(BinlogOffset highWatermark) {
            this.highWatermark = highWatermark;
        }

        public boolean isRunning() {
            return this.lowWatermark != null && this.highWatermark != null;
        }
    }
}

