/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase;

import com.ververica.cdc.connectors.oceanbase.source.OceanBaseRichSourceFunction;
import com.ververica.cdc.connectors.oceanbase.table.StartupMode;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import java.time.Duration;
import java.time.ZoneId;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public class OceanBaseSource {
    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private StartupMode startupMode;
        private Long startupTimestamp;
        private String username;
        private String password;
        private String tenantName;
        private String databaseName;
        private String tableName;
        private String hostname;
        private Integer port;
        private Duration connectTimeout;
        private String rsList;
        private String logProxyHost;
        private Integer logProxyPort;
        private ZoneId serverTimeZone = ZoneId.of("UTC");
        private DebeziumDeserializationSchema<T> deserializer;

        public Builder<T> startupMode(StartupMode startupMode) {
            this.startupMode = startupMode;
            return this;
        }

        public Builder<T> startupTimestamp(Long startupTimestamp) {
            this.startupTimestamp = startupTimestamp;
            return this;
        }

        public Builder<T> username(String username) {
            this.username = username;
            return this;
        }

        public Builder<T> password(String password) {
            this.password = password;
            return this;
        }

        public Builder<T> tenantName(String tenantName) {
            this.tenantName = tenantName;
            return this;
        }

        public Builder<T> databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public Builder<T> tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder<T> hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public Builder<T> port(int port) {
            this.port = port;
            return this;
        }

        public Builder<T> connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder<T> rsList(String rsList) {
            this.rsList = rsList;
            return this;
        }

        public Builder<T> logProxyHost(String logProxyHost) {
            this.logProxyHost = logProxyHost;
            return this;
        }

        public Builder<T> logProxyPort(int logProxyPort) {
            this.logProxyPort = logProxyPort;
            return this;
        }

        public Builder<T> serverTimeZone(ZoneId serverTimeZone) {
            this.serverTimeZone = serverTimeZone;
            return this;
        }

        public Builder<T> deserializer(DebeziumDeserializationSchema<T> deserializer) {
            this.deserializer = deserializer;
            return this;
        }

        public SourceFunction<T> build() {
            switch (this.startupMode) {
                case INITIAL: 
                case LATEST_OFFSET: {
                    this.startupTimestamp = 0L;
                    break;
                }
                case TIMESTAMP: {
                    Preconditions.checkNotNull((Object)this.startupTimestamp, (String)"startupTimestamp shouldn't be null");
                    break;
                }
                default: {
                    throw new UnsupportedOperationException((Object)((Object)this.startupMode) + " mode is not supported.");
                }
            }
            return new OceanBaseRichSourceFunction(this.startupMode.equals((Object)StartupMode.INITIAL), (Long)Preconditions.checkNotNull((Object)this.startupTimestamp), (String)Preconditions.checkNotNull((Object)this.username), (String)Preconditions.checkNotNull((Object)this.password), (String)Preconditions.checkNotNull((Object)this.tenantName), (String)Preconditions.checkNotNull((Object)this.databaseName), (String)Preconditions.checkNotNull((Object)this.tableName), this.hostname, this.port, this.connectTimeout, (String)Preconditions.checkNotNull((Object)this.rsList), (String)Preconditions.checkNotNull((Object)this.logProxyHost), (Integer)Preconditions.checkNotNull((Object)this.logProxyPort), (ZoneId)Preconditions.checkNotNull((Object)this.serverTimeZone), (DebeziumDeserializationSchema)Preconditions.checkNotNull(this.deserializer));
        }
    }
}

