/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.source;

import com.oceanbase.oms.logmessage.ByteString;
import com.oceanbase.oms.logmessage.DataMessage;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.jdbc.JdbcValueConverters;
import io.debezium.jdbc.TemporalPrecisionMode;
import io.debezium.relational.ValueConverterProvider;
import io.debezium.time.MicroTime;
import io.debezium.time.MicroTimestamp;
import io.debezium.util.NumberConversions;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.util.Arrays;
import org.apache.kafka.connect.data.Schema;

public class OceanBaseJdbcConverter {
    public static ValueConverterProvider valueConverterProvider(ZoneOffset zoneOffset) {
        return new JdbcValueConverters(JdbcValueConverters.DecimalMode.STRING, TemporalPrecisionMode.ADAPTIVE_TIME_MICROSECONDS, zoneOffset, null, JdbcValueConverters.BigIntUnsignedMode.PRECISE, CommonConnectorConfig.BinaryHandlingMode.BYTES);
    }

    public static Object getField(int jdbcType, Object value) {
        if (value == null) {
            return null;
        }
        jdbcType = OceanBaseJdbcConverter.getType(jdbcType, null);
        switch (jdbcType) {
            case -7: {
                if (value instanceof Boolean) {
                    return new byte[]{NumberConversions.getByte((boolean)((Boolean)value))};
                }
                return value;
            }
            case 4: {
                if (value instanceof Boolean) {
                    return NumberConversions.getInteger((Boolean)((Boolean)value));
                }
                if (value instanceof Date) {
                    return ((Date)value).getYear() + 1900;
                }
                return value;
            }
            case 6: {
                Float f = (Float)value;
                return f.doubleValue();
            }
            case 3: {
                if (value instanceof BigInteger) {
                    return value.toString();
                }
                BigDecimal decimal = (BigDecimal)value;
                return decimal.toString();
            }
            case 91: {
                Date date = (Date)value;
                return io.debezium.time.Date.toEpochDay((Object)date, null);
            }
            case 92: {
                Time time = (Time)value;
                return MicroTime.toMicroOfDay((Object)time, (boolean)true);
            }
            case 93: {
                Timestamp timestamp = (Timestamp)value;
                return MicroTimestamp.toEpochMicros((Object)timestamp, null);
            }
        }
        return value;
    }

    public static Object getField(Schema.Type schemaType, DataMessage.Record.Field.Type fieldType, ByteString value) {
        if (value == null) {
            return null;
        }
        int jdbcType = OceanBaseJdbcConverter.getType(fieldType);
        switch (jdbcType) {
            case 0: {
                return null;
            }
            case 4: {
                if (schemaType.equals((Object)Schema.Type.INT64)) {
                    return Long.parseLong(value.toString());
                }
                return Integer.parseInt(value.toString());
            }
            case -5: {
                if (schemaType.equals((Object)Schema.Type.STRING)) {
                    return value.toString();
                }
                return Long.parseLong(value.toString());
            }
            case 8: {
                return Double.parseDouble(value.toString());
            }
            case 91: {
                Date date = Date.valueOf(value.toString());
                return io.debezium.time.Date.toEpochDay((Object)date, null);
            }
            case 92: {
                Time time = Time.valueOf(value.toString());
                return MicroTime.toMicroOfDay((Object)time, (boolean)true);
            }
            case 93: {
                Timestamp timestamp = Timestamp.valueOf(value.toString());
                return MicroTimestamp.toEpochMicros((Object)timestamp, null);
            }
            case -7: {
                int i;
                long v = Long.parseLong(value.toString());
                byte[] bytes = ByteBuffer.allocate(8).putLong(v).array();
                for (i = 0; bytes[i] == 0 && i < 7; ++i) {
                }
                return Arrays.copyOfRange(bytes, i, 8);
            }
            case -2: {
                return ByteBuffer.wrap(value.toString().getBytes(StandardCharsets.UTF_8));
            }
        }
        return value.toString();
    }

    private static boolean isBoolean(int jdbcType, String typeName) {
        return jdbcType == 16 || jdbcType == -7 && "TINYINT".equals(typeName);
    }

    public static int getType(int jdbcType, String typeName) {
        if (OceanBaseJdbcConverter.isBoolean(jdbcType, typeName)) {
            jdbcType = -6;
        }
        if ("YEAR".equals(typeName)) {
            jdbcType = 4;
        }
        if ("INT UNSIGNED".equals(typeName)) {
            jdbcType = -5;
        }
        if ("BIGINT UNSIGNED".equals(typeName)) {
            jdbcType = 3;
        }
        switch (jdbcType) {
            case -6: 
            case 5: {
                return 4;
            }
            case 7: {
                return 6;
            }
        }
        return jdbcType;
    }

    public static int getType(DataMessage.Record.Field.Type fieldType) {
        switch (fieldType) {
            case NULL: {
                return 0;
            }
            case INT8: 
            case INT16: 
            case INT24: 
            case INT32: 
            case YEAR: {
                return 4;
            }
            case INT64: {
                return -5;
            }
            case FLOAT: 
            case DOUBLE: {
                return 8;
            }
            case DECIMAL: {
                return 3;
            }
            case ENUM: 
            case SET: 
            case STRING: 
            case JSON: {
                return 1;
            }
            case TIMESTAMP: 
            case DATETIME: 
            case TIMESTAMP_WITH_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
            case TIMESTAMP_NANO: {
                return 93;
            }
            case DATE: {
                return 91;
            }
            case TIME: {
                return 92;
            }
            case BIT: {
                return -7;
            }
            case BLOB: 
            case BINARY: {
                return -2;
            }
        }
        return 12;
    }
}

