/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.table;

import com.ververica.cdc.debezium.table.MetadataConverter;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.data.StringData;
import org.apache.flink.table.data.TimestampData;
import org.apache.flink.table.types.DataType;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public enum OceanBaseReadableMetadata {
    TENANT("tenant_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct source = value.getStruct("source");
            return StringData.fromString((String)source.getString("tenant"));
        }
    }),
    DATABASE("database_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct source = value.getStruct("source");
            return StringData.fromString((String)source.getString("database"));
        }
    }),
    TABLE("table_name", (DataType)DataTypes.STRING().notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct source = value.getStruct("source");
            return StringData.fromString((String)source.getString("table"));
        }
    }),
    OP_TS("op_ts", (DataType)DataTypes.TIMESTAMP_LTZ((int)3).notNull(), new MetadataConverter(){
        private static final long serialVersionUID = 1L;

        public Object read(SourceRecord record) {
            Struct value = (Struct)record.value();
            Struct source = value.getStruct("source");
            String timestamp = source.getString("timestamp");
            if (timestamp == null) {
                timestamp = "0";
            }
            return TimestampData.fromEpochMillis((long)(Long.parseLong(timestamp) * 1000L));
        }
    });

    private final String key;
    private final DataType dataType;
    private final MetadataConverter converter;

    private OceanBaseReadableMetadata(String key, DataType dataType, MetadataConverter converter) {
        this.key = key;
        this.dataType = dataType;
        this.converter = converter;
    }

    public String getKey() {
        return this.key;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public MetadataConverter getConverter() {
        return this.converter;
    }
}

