/*
 * Decompiled with CFR 0.152.
 */
package com.ververica.cdc.connectors.oceanbase.table;

import com.ververica.cdc.connectors.oceanbase.table.OceanBaseTableSource;
import com.ververica.cdc.connectors.oceanbase.table.StartupMode;
import java.time.Duration;
import java.time.ZoneId;
import java.util.HashSet;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.connector.source.DynamicTableSource;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.DynamicTableSourceFactory;
import org.apache.flink.table.factories.FactoryUtil;

public class OceanBaseTableSourceFactory
implements DynamicTableSourceFactory {
    private static final String IDENTIFIER = "oceanbase-cdc";
    public static final ConfigOption<String> SCAN_STARTUP_MODE = ConfigOptions.key((String)"scan.startup.mode").stringType().defaultValue((Object)"initial").withDescription("Optional startup mode for OceanBase CDC consumer, valid enumerations are \"initial\", \"latest-offset\" or \"timestamp\"");
    public static final ConfigOption<Long> SCAN_STARTUP_TIMESTAMP = ConfigOptions.key((String)"scan.startup.timestamp").longType().noDefaultValue().withDescription("Optional timestamp in seconds used in case of \"timestamp\" startup mode.");
    public static final ConfigOption<String> USERNAME = ConfigOptions.key((String)"username").stringType().noDefaultValue().withDescription("Username to be used when connecting to OceanBase.");
    public static final ConfigOption<String> PASSWORD = ConfigOptions.key((String)"password").stringType().noDefaultValue().withDescription("Password to be used when connecting to OceanBase.");
    public static final ConfigOption<String> TENANT_NAME = ConfigOptions.key((String)"tenant-name").stringType().noDefaultValue().withDescription("Tenant name of OceanBase to monitor.");
    public static final ConfigOption<String> DATABASE_NAME = ConfigOptions.key((String)"database-name").stringType().noDefaultValue().withDescription("Database name of OceanBase to monitor.");
    public static final ConfigOption<String> TABLE_NAME = ConfigOptions.key((String)"table-name").stringType().noDefaultValue().withDescription("Table name of OceanBase to monitor.");
    public static final ConfigOption<String> HOSTNAME = ConfigOptions.key((String)"hostname").stringType().noDefaultValue().withDescription("IP address or hostname of the OceanBase database server or OceanBase proxy server.");
    public static final ConfigOption<Integer> PORT = ConfigOptions.key((String)"port").intType().noDefaultValue().withDescription("Integer port number of OceanBase database server or OceanBase proxy server.");
    public static final ConfigOption<Duration> CONNECT_TIMEOUT = ConfigOptions.key((String)"connect.timeout").durationType().defaultValue((Object)Duration.ofSeconds(30L)).withDescription("The maximum time that the connector should wait after trying to connect to the OceanBase database server before timing out.");
    public static final ConfigOption<String> SERVER_TIME_ZONE = ConfigOptions.key((String)"server-time-zone").stringType().defaultValue((Object)"UTC").withDescription("The session time zone in database server.");
    public static final ConfigOption<String> RS_LIST = ConfigOptions.key((String)"rootserver-list").stringType().noDefaultValue().withDescription("The semicolon-separated list of OceanBase root servers in format `ip:rpc_port:sql_port`.");
    public static final ConfigOption<String> LOG_PROXY_HOST = ConfigOptions.key((String)"logproxy.host").stringType().noDefaultValue().withDescription("Hostname or IP address of OceanBase log proxy service.");
    public static final ConfigOption<Integer> LOG_PROXY_PORT = ConfigOptions.key((String)"logproxy.port").intType().noDefaultValue().withDescription("Port number of OceanBase log proxy service.");

    public DynamicTableSource createDynamicTableSource(DynamicTableFactory.Context context) {
        FactoryUtil.TableFactoryHelper helper = FactoryUtil.createTableFactoryHelper((DynamicTableFactory)this, (DynamicTableFactory.Context)context);
        helper.validate();
        ResolvedSchema physicalSchema = context.getCatalogTable().getResolvedSchema();
        ReadableConfig config = helper.getOptions();
        StartupMode startupMode = StartupMode.getStartupMode((String)config.get(SCAN_STARTUP_MODE));
        Long startupTimestamp = (Long)config.get(SCAN_STARTUP_TIMESTAMP);
        String username = (String)config.get(USERNAME);
        String password = (String)config.get(PASSWORD);
        String tenantName = (String)config.get(TENANT_NAME);
        String databaseName = (String)config.get(DATABASE_NAME);
        String tableName = (String)config.get(TABLE_NAME);
        String rsList = (String)config.get(RS_LIST);
        String logProxyHost = (String)config.get(LOG_PROXY_HOST);
        int logProxyPort = (Integer)config.get(LOG_PROXY_PORT);
        String hostname = (String)config.get(HOSTNAME);
        Integer port = (Integer)config.get(PORT);
        Duration connectTimeout = (Duration)config.get(CONNECT_TIMEOUT);
        ZoneId serverTimeZone = ZoneId.of((String)config.get(SERVER_TIME_ZONE));
        return new OceanBaseTableSource(physicalSchema, startupMode, startupTimestamp, username, password, tenantName, databaseName, tableName, hostname, port, connectTimeout, serverTimeZone, rsList, logProxyHost, logProxyPort);
    }

    public String factoryIdentifier() {
        return IDENTIFIER;
    }

    public Set<ConfigOption<?>> requiredOptions() {
        HashSet options = new HashSet();
        options.add(SCAN_STARTUP_MODE);
        options.add(USERNAME);
        options.add(PASSWORD);
        options.add(TENANT_NAME);
        options.add(DATABASE_NAME);
        options.add(TABLE_NAME);
        options.add(RS_LIST);
        options.add(LOG_PROXY_HOST);
        options.add(LOG_PROXY_PORT);
        return options;
    }

    public Set<ConfigOption<?>> optionalOptions() {
        HashSet options = new HashSet();
        options.add(SCAN_STARTUP_TIMESTAMP);
        options.add(HOSTNAME);
        options.add(PORT);
        options.add(CONNECT_TIMEOUT);
        options.add(SERVER_TIME_ZONE);
        return options;
    }
}

