/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.filter;

import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.Activation;
import com.weibo.api.motan.core.extension.SpiMeta;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.filter.Filter;
import com.weibo.api.motan.rpc.Caller;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.RpcStats;

@SpiMeta(name="active")
@Activation(sequence=1)
public class ActiveLimitFilter
implements Filter {
    @Override
    public Response filter(Caller<?> caller, Request request) {
        int activeCount;
        int maxAcvitivyCount = caller.getUrl().getIntParameter(URLParamType.actives.getName(), URLParamType.actives.getIntValue());
        if (maxAcvitivyCount > 0 && (activeCount = RpcStats.getServiceStat(caller.getUrl()).getActiveCount()) >= maxAcvitivyCount) {
            throw new MotanServiceException(String.format("Request(%s) active count exceed the limit (%s), referer:%s", request, maxAcvitivyCount, caller.getUrl()), MotanErrorMsgConstant.SERVICE_REJECT);
        }
        long startTime = System.currentTimeMillis();
        RpcStats.beforeCall(caller.getUrl(), request);
        try {
            Response rs = caller.call(request);
            RpcStats.afterCall(caller.getUrl(), request, true, System.currentTimeMillis() - startTime);
            return rs;
        }
        catch (RuntimeException re) {
            RpcStats.afterCall(caller.getUrl(), request, false, System.currentTimeMillis() - startTime);
            throw re;
        }
    }
}

