/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.protocol.restful.support;

import com.weibo.api.motan.protocol.restful.EndpointFactory;
import com.weibo.api.motan.protocol.restful.RestServer;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyClientBuilder;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;

public abstract class AbstractEndpointFactory
implements EndpointFactory {
    protected final Map<String, RestServer> ipPort2ServerShareChannel = new HashMap<String, RestServer>();
    protected final Map<String, ResteasyWebTarget> ipPort2ClientShareChannel = new HashMap<String, ResteasyWebTarget>();
    protected Map<RestServer, Set<String>> server2UrlsShareChannel = new HashMap<RestServer, Set<String>>();
    protected Map<ResteasyWebTarget, Set<String>> client2UrlsShareChannel = new HashMap<ResteasyWebTarget, Set<String>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RestServer createServer(URL url) {
        String ipPort = url.getServerPortStr();
        String protocolKey = MotanFrameworkUtil.getProtocolKey((URL)url);
        LoggerUtil.info((String)(this.getClass().getSimpleName() + " create share_channel server: url={}"), (Object[])new Object[]{url});
        Map<String, RestServer> map = this.ipPort2ServerShareChannel;
        synchronized (map) {
            RestServer server = this.ipPort2ServerShareChannel.get(ipPort);
            if (server != null) {
                this.saveEndpoint2Urls(this.server2UrlsShareChannel, server, protocolKey);
                return server;
            }
            url = url.createCopy();
            url.setPath("");
            server = this.innerCreateServer(url);
            server.start();
            this.ipPort2ServerShareChannel.put(ipPort, server);
            this.saveEndpoint2Urls(this.server2UrlsShareChannel, server, protocolKey);
            return server;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResteasyWebTarget createClient(URL url) {
        String ipPort = url.getServerPortStr();
        String protocolKey = MotanFrameworkUtil.getProtocolKey((URL)url);
        LoggerUtil.info((String)(this.getClass().getSimpleName() + " create share_channel client: url={}"), (Object[])new Object[]{url});
        Map<String, ResteasyWebTarget> map = this.ipPort2ClientShareChannel;
        synchronized (map) {
            ResteasyWebTarget client = this.ipPort2ClientShareChannel.get(ipPort);
            if (client != null) {
                this.saveEndpoint2Urls(this.client2UrlsShareChannel, client, protocolKey);
                return client;
            }
            client = this.innerCreateClient(url);
            this.ipPort2ClientShareChannel.put(ipPort, client);
            this.saveEndpoint2Urls(this.client2UrlsShareChannel, client, protocolKey);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void safeReleaseResource(RestServer server, URL url) {
        String ipPort = url.getServerPortStr();
        String protocolKey = MotanFrameworkUtil.getProtocolKey((URL)url);
        Map<String, RestServer> map = this.ipPort2ServerShareChannel;
        synchronized (map) {
            if (server != this.ipPort2ServerShareChannel.get(ipPort)) {
                server.stop();
                return;
            }
            Set<String> urls = this.server2UrlsShareChannel.get(server);
            urls.remove(protocolKey);
            if (urls.isEmpty()) {
                server.stop();
                this.ipPort2ServerShareChannel.remove(ipPort);
                this.server2UrlsShareChannel.remove(server);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void safeReleaseResource(ResteasyWebTarget client, URL url) {
        String ipPort = url.getServerPortStr();
        String protocolKey = MotanFrameworkUtil.getProtocolKey((URL)url);
        Map<String, ResteasyWebTarget> map = this.ipPort2ClientShareChannel;
        synchronized (map) {
            if (client != this.ipPort2ClientShareChannel.get(ipPort)) {
                client.getResteasyClient().close();
                return;
            }
            Set<String> urls = this.client2UrlsShareChannel.get(client);
            urls.remove(protocolKey);
            if (urls.isEmpty()) {
                client.getResteasyClient().close();
                this.ipPort2ClientShareChannel.remove(ipPort);
                this.client2UrlsShareChannel.remove(client);
            }
        }
    }

    private <T> void saveEndpoint2Urls(Map<T, Set<String>> map, T endpoint, String protocolKey) {
        Set<String> sets = map.get(endpoint);
        if (sets == null) {
            sets = new HashSet<String>();
            map.put(endpoint, sets);
        }
        sets.add(protocolKey);
    }

    protected abstract RestServer innerCreateServer(URL var1);

    protected ResteasyWebTarget innerCreateClient(URL url) {
        ResteasyClient client = new ResteasyClientBuilder().build();
        String contextpath = url.getParameter("contextpath", "/");
        if (!contextpath.startsWith("/")) {
            contextpath = "/" + contextpath;
        }
        return client.target("http://" + url.getHost() + ":" + url.getPort() + contextpath);
    }
}

