/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.registry.consul;

import com.weibo.api.motan.registry.consul.ConsulConstants;
import com.weibo.api.motan.registry.consul.client.MotanConsulClient;
import com.weibo.api.motan.util.ConcurrentHashSet;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ConsulHeartbeatManager {
    private MotanConsulClient client;
    private ConcurrentHashSet<String> serviceIds = new ConcurrentHashSet();
    private ThreadPoolExecutor jobExecutor;
    private ScheduledExecutorService heartbeatExecutor;
    private boolean lastHeartBeatSwitcherStatus = false;
    private volatile boolean currentHeartBeatSwitcherStatus = false;
    private int switcherCheckTimes = 0;

    public ConsulHeartbeatManager(MotanConsulClient client) {
        this.client = client;
        this.heartbeatExecutor = Executors.newSingleThreadScheduledExecutor();
        ArrayBlockingQueue<Runnable> workQueue = new ArrayBlockingQueue<Runnable>(10000);
        this.jobExecutor = new ThreadPoolExecutor(5, 30, 30000L, TimeUnit.MILLISECONDS, workQueue);
    }

    public void start() {
        this.heartbeatExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    boolean switcherStatus = ConsulHeartbeatManager.this.isHeartbeatOpen();
                    if (ConsulHeartbeatManager.this.isSwitcherChange(switcherStatus)) {
                        ConsulHeartbeatManager.this.processHeartbeat(switcherStatus);
                    } else if (switcherStatus) {
                        ConsulHeartbeatManager.this.switcherCheckTimes++;
                        if (ConsulHeartbeatManager.this.switcherCheckTimes >= ConsulConstants.MAX_SWITCHER_CHECK_TIMES) {
                            ConsulHeartbeatManager.this.processHeartbeat(true);
                            ConsulHeartbeatManager.this.switcherCheckTimes = 0;
                        }
                    }
                }
                catch (Exception e) {
                    LoggerUtil.error((String)"consul heartbeat executor err:", (Throwable)e);
                }
            }
        }, ConsulConstants.SWITCHER_CHECK_CIRCLE, ConsulConstants.SWITCHER_CHECK_CIRCLE, TimeUnit.MILLISECONDS);
    }

    private boolean isSwitcherChange(boolean switcherStatus) {
        boolean ret = false;
        if (switcherStatus != this.lastHeartBeatSwitcherStatus) {
            ret = true;
            this.lastHeartBeatSwitcherStatus = switcherStatus;
            LoggerUtil.info((String)("heartbeat switcher change to " + switcherStatus));
        }
        return ret;
    }

    protected void processHeartbeat(boolean isPass) {
        for (String serviceid : this.serviceIds) {
            try {
                this.jobExecutor.execute(new HeartbeatJob(serviceid, isPass));
            }
            catch (RejectedExecutionException ree) {
                LoggerUtil.error((String)("execute heartbeat job fail! serviceid:" + serviceid + " is rejected"));
            }
        }
    }

    public void close() {
        this.heartbeatExecutor.shutdown();
        this.jobExecutor.shutdown();
        LoggerUtil.info((String)"Consul heartbeatManager closed.");
    }

    public void addHeartbeatServcieId(String serviceid) {
        this.serviceIds.add((Object)serviceid);
    }

    public void removeHeartbeatServiceId(String serviceid) {
        this.serviceIds.remove((Object)serviceid);
    }

    private boolean isHeartbeatOpen() {
        return this.currentHeartBeatSwitcherStatus;
    }

    public void setHeartbeatOpen(boolean open) {
        this.currentHeartBeatSwitcherStatus = open;
    }

    public void setClient(MotanConsulClient client) {
        this.client = client;
    }

    class HeartbeatJob
    implements Runnable {
        private String serviceid;
        private boolean isPass;

        public HeartbeatJob(String serviceid, boolean isPass) {
            this.serviceid = serviceid;
            this.isPass = isPass;
        }

        @Override
        public void run() {
            try {
                if (this.isPass) {
                    ConsulHeartbeatManager.this.client.checkPass(this.serviceid);
                } else {
                    ConsulHeartbeatManager.this.client.checkFail(this.serviceid);
                }
            }
            catch (Exception e) {
                LoggerUtil.error((String)("consul heartbeat-set check pass error!serviceid:" + this.serviceid), (Throwable)e);
            }
        }
    }
}

