/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.protocol.v2motan.MotanV2Codec;
import com.weibo.api.motan.rpc.DefaultResponse;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.util.ByteUtil;
import com.weibo.api.motan.util.LoggerUtil;
import java.io.IOException;

public class CodecUtil {
    public static byte[] encodeObjectToBytes(Channel channel, Codec codec, Object msg) {
        try {
            if (codec instanceof MotanV2Codec) {
                return CodecUtil.encodeV2(channel, codec, msg);
            }
            return CodecUtil.encodeV1(channel, codec, msg);
        }
        catch (IOException e) {
            throw new MotanFrameworkException("encode error: isResponse=" + (msg instanceof Response), (Throwable)e, MotanErrorMsgConstant.FRAMEWORK_ENCODE_ERROR);
        }
    }

    private static byte[] encodeV2(Channel channel, Codec codec, Object msg) throws IOException {
        return CodecUtil.encodeMessage(channel, codec, msg);
    }

    private static byte[] encodeV1(Channel channel, Codec codec, Object msg) throws IOException {
        long requestId = CodecUtil.getRequestId(msg);
        byte[] data = CodecUtil.encodeMessage(channel, codec, msg);
        byte[] result = new byte[16 + data.length];
        ByteUtil.short2bytes((short)-3599, (byte[])result, (int)0);
        result[3] = CodecUtil.getType(msg);
        ByteUtil.long2bytes((long)requestId, (byte[])result, (int)4);
        ByteUtil.int2bytes((int)data.length, (byte[])result, (int)12);
        System.arraycopy(data, 0, result, 16, data.length);
        return result;
    }

    private static byte[] encodeMessage(Channel channel, Codec codec, Object msg) throws IOException {
        byte[] data;
        if (msg instanceof Response) {
            try {
                data = codec.encode(channel, msg);
            }
            catch (Exception e) {
                LoggerUtil.error((String)("NettyEncoder encode error, identity=" + channel.getUrl().getIdentity()), (Throwable)e);
                long requestId = CodecUtil.getRequestId(msg);
                Response response = CodecUtil.buildExceptionResponse(requestId, e);
                data = codec.encode(channel, (Object)response);
            }
        } else {
            data = codec.encode(channel, msg);
        }
        return data;
    }

    private static long getRequestId(Object message) {
        if (message instanceof Request) {
            return ((Request)message).getRequestId();
        }
        if (message instanceof Response) {
            return ((Response)message).getRequestId();
        }
        return 0L;
    }

    private static Response buildExceptionResponse(long requestId, Exception e) {
        DefaultResponse response = new DefaultResponse();
        response.setRequestId(requestId);
        response.setException(e);
        return response;
    }

    private static byte getType(Object message) {
        if (message instanceof Request) {
            return 0;
        }
        if (message instanceof Response) {
            return 1;
        }
        return -1;
    }
}

