/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.codec.Codec;
import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.extension.ExtensionLoader;
import com.weibo.api.motan.exception.MotanErrorMsgConstant;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.exception.MotanServiceException;
import com.weibo.api.motan.rpc.DefaultResponseFuture;
import com.weibo.api.motan.rpc.Future;
import com.weibo.api.motan.rpc.FutureListener;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.ResponseFuture;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.transport.netty4.CodecUtil;
import com.weibo.api.motan.transport.netty4.NettyClient;
import com.weibo.api.motan.util.ExceptionUtil;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.MotanFrameworkUtil;
import io.netty.channel.ChannelFuture;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class NettyChannel
implements Channel {
    private volatile ChannelState state = ChannelState.UNINIT;
    private NettyClient nettyClient;
    private io.netty.channel.Channel channel = null;
    private InetSocketAddress remoteAddress = null;
    private InetSocketAddress localAddress = null;
    private ReentrantLock lock = new ReentrantLock();
    private Codec codec;

    public NettyChannel(NettyClient nettyClient) {
        this.nettyClient = nettyClient;
        this.remoteAddress = new InetSocketAddress(nettyClient.getUrl().getHost(), (int)nettyClient.getUrl().getPort());
        this.codec = (Codec)ExtensionLoader.getExtensionLoader(Codec.class).getExtension(nettyClient.getUrl().getParameter(URLParamType.codec.getName(), URLParamType.codec.getValue()));
    }

    public InetSocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public Response request(Request request) throws TransportException {
        int timeout = this.nettyClient.getUrl().getMethodParameter(request.getMethodName(), request.getParamtersDesc(), URLParamType.requestTimeout.getName(), URLParamType.requestTimeout.getIntValue());
        if (timeout <= 0) {
            throw new MotanFrameworkException("NettyClient init Error: timeout(" + timeout + ") <= 0 is forbid.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
        }
        DefaultResponseFuture response = new DefaultResponseFuture(request, timeout, this.nettyClient.getUrl());
        this.nettyClient.registerCallback(request.getRequestId(), (ResponseFuture)response);
        byte[] msg = CodecUtil.encodeObjectToBytes(this, this.codec, request);
        ChannelFuture writeFuture = this.channel.writeAndFlush((Object)msg);
        boolean result = writeFuture.awaitUninterruptibly((long)timeout, TimeUnit.MILLISECONDS);
        if (result && writeFuture.isSuccess()) {
            response.addListener(new FutureListener(){

                public void operationComplete(Future future) throws Exception {
                    if (future.isSuccess() || future.isDone() && ExceptionUtil.isBizException((Exception)future.getException())) {
                        NettyChannel.this.nettyClient.resetErrorCount();
                    } else {
                        NettyChannel.this.nettyClient.incrErrorCount();
                    }
                }
            });
            return response;
        }
        writeFuture.cancel(true);
        response = this.nettyClient.removeCallback(request.getRequestId());
        if (response != null) {
            response.cancel();
        }
        this.nettyClient.incrErrorCount();
        if (writeFuture.cause() != null) {
            throw new MotanServiceException("NettyChannel send request to server Error: url=" + this.nettyClient.getUrl().getUri() + " local=" + this.localAddress + " " + MotanFrameworkUtil.toString((Request)request), writeFuture.cause());
        }
        throw new MotanServiceException("NettyChannel send request to server Timeout: url=" + this.nettyClient.getUrl().getUri() + " local=" + this.localAddress + " " + MotanFrameworkUtil.toString((Request)request));
    }

    public synchronized boolean open() {
        if (this.isAvailable()) {
            LoggerUtil.warn((String)("the channel already open, local: " + this.localAddress + " remote: " + this.remoteAddress + " url: " + this.nettyClient.getUrl().getUri()));
            return true;
        }
        try {
            long start = System.currentTimeMillis();
            ChannelFuture channelFuture = this.nettyClient.getBootstrap().connect((SocketAddress)this.remoteAddress);
            int timeout = this.nettyClient.getUrl().getIntParameter(URLParamType.connectTimeout.getName(), URLParamType.connectTimeout.getIntValue());
            if (timeout <= 0) {
                throw new MotanFrameworkException("NettyClient init Error: timeout(" + timeout + ") <= 0 is forbid.", MotanErrorMsgConstant.FRAMEWORK_INIT_ERROR);
            }
            boolean result = channelFuture.awaitUninterruptibly((long)timeout, TimeUnit.MILLISECONDS);
            boolean success = channelFuture.isSuccess();
            if (result && success) {
                this.channel = channelFuture.channel();
                if (this.channel.localAddress() != null && this.channel.localAddress() instanceof InetSocketAddress) {
                    this.localAddress = (InetSocketAddress)this.channel.localAddress();
                }
                this.state = ChannelState.ALIVE;
                boolean bl = true;
                return bl;
            }
            try {
                boolean connected = false;
                if (channelFuture.channel() != null) {
                    connected = channelFuture.channel().isActive();
                }
                if (channelFuture.cause() != null) {
                    channelFuture.cancel(true);
                    throw new MotanServiceException("NettyChannel failed to connect to server, url: " + this.nettyClient.getUrl().getUri() + ", result: " + result + ", success: " + success + ", connected: " + connected, channelFuture.cause());
                }
                channelFuture.cancel(true);
                throw new MotanServiceException("NettyChannel connect to server timeout url: " + this.nettyClient.getUrl().getUri() + ", cost: " + (System.currentTimeMillis() - start) + ", result: " + result + ", success: " + success + ", connected: " + connected);
            }
            catch (MotanServiceException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MotanServiceException("NettyChannel failed to connect to server, url: " + this.nettyClient.getUrl().getUri(), (Throwable)e);
            }
        }
        finally {
            if (!this.state.isAliveState()) {
                this.nettyClient.incrErrorCount();
            }
        }
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int timeout) {
        try {
            this.state = ChannelState.CLOSE;
            if (this.channel != null) {
                this.channel.close();
            }
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyChannel close Error: " + this.nettyClient.getUrl().getUri() + " local=" + this.localAddress), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.state.isCloseState();
    }

    public boolean isAvailable() {
        return this.state.isAliveState() && this.channel != null && this.channel.isActive();
    }

    public void reconnect() {
        this.state = ChannelState.INIT;
    }

    public boolean isReconnect() {
        return this.state.isInitState();
    }

    public URL getUrl() {
        return this.nettyClient.getUrl();
    }

    public ReentrantLock getLock() {
        return this.lock;
    }
}

