/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.common.ChannelState;
import com.weibo.api.motan.common.URLParamType;
import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.exception.MotanFrameworkException;
import com.weibo.api.motan.rpc.Request;
import com.weibo.api.motan.rpc.Response;
import com.weibo.api.motan.rpc.URL;
import com.weibo.api.motan.transport.AbstractServer;
import com.weibo.api.motan.transport.Channel;
import com.weibo.api.motan.transport.MessageHandler;
import com.weibo.api.motan.transport.TransportException;
import com.weibo.api.motan.transport.netty4.NettyChannelHandler;
import com.weibo.api.motan.transport.netty4.NettyDecoder;
import com.weibo.api.motan.transport.netty4.NettyEncoder;
import com.weibo.api.motan.transport.netty4.NettyServerChannelManage;
import com.weibo.api.motan.util.LoggerUtil;
import com.weibo.api.motan.util.StatisticCallback;
import com.weibo.api.motan.util.StatsUtil;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;

public class NettyServer
extends AbstractServer
implements StatisticCallback {
    protected NettyServerChannelManage channelManage = null;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private io.netty.channel.Channel serverChannel;
    private MessageHandler messageHandler;
    private StandardThreadExecutor standardThreadExecutor = null;

    public NettyServer(URL url, MessageHandler messageHandler) {
        super(url);
        this.messageHandler = messageHandler;
    }

    public boolean isBound() {
        return this.serverChannel != null && this.serverChannel.isActive();
    }

    public Response request(Request request) throws TransportException {
        throw new MotanFrameworkException("NettyServer request(Request request) method not support: url: " + this.url);
    }

    public boolean open() {
        int maxWorkerThread;
        int minWorkerThread;
        if (this.isAvailable()) {
            LoggerUtil.warn((String)("NettyServer ServerChannel already Open: url=" + this.url));
            return this.state.isAliveState();
        }
        if (this.bossGroup == null) {
            this.bossGroup = new NioEventLoopGroup(1);
            this.workerGroup = new NioEventLoopGroup();
        }
        LoggerUtil.info((String)("NettyServer ServerChannel start Open: url=" + this.url));
        boolean shareChannel = this.url.getBooleanParameter(URLParamType.shareChannel.getName(), URLParamType.shareChannel.getBooleanValue());
        final int maxContentLength = this.url.getIntParameter(URLParamType.maxContentLength.getName(), URLParamType.maxContentLength.getIntValue());
        int maxServerConnection = this.url.getIntParameter(URLParamType.maxServerConnection.getName(), URLParamType.maxServerConnection.getIntValue());
        int workerQueueSize = this.url.getIntParameter(URLParamType.workerQueueSize.getName(), URLParamType.workerQueueSize.getIntValue());
        if (shareChannel) {
            minWorkerThread = this.url.getIntParameter(URLParamType.minWorkerThread.getName(), 40);
            maxWorkerThread = this.url.getIntParameter(URLParamType.maxWorkerThread.getName(), 800);
        } else {
            minWorkerThread = this.url.getIntParameter(URLParamType.minWorkerThread.getName(), 20);
            maxWorkerThread = this.url.getIntParameter(URLParamType.maxWorkerThread.getName(), 200);
        }
        this.standardThreadExecutor = this.standardThreadExecutor != null && !this.standardThreadExecutor.isShutdown() ? this.standardThreadExecutor : new StandardThreadExecutor(minWorkerThread, maxWorkerThread, workerQueueSize, (ThreadFactory)new DefaultThreadFactory("NettyServer-" + this.url.getServerPortStr(), true));
        this.standardThreadExecutor.prestartAllCoreThreads();
        this.channelManage = new NettyServerChannelManage(maxServerConnection);
        ServerBootstrap serverBootstrap = new ServerBootstrap();
        ((ServerBootstrap)serverBootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("decoder", (ChannelHandler)new NettyDecoder(NettyServer.this.codec, (Channel)NettyServer.this, maxContentLength));
                pipeline.addLast("encoder", (ChannelHandler)new NettyEncoder());
                pipeline.addLast("handler", (ChannelHandler)new NettyChannelHandler((Channel)NettyServer.this, NettyServer.this.messageHandler, (ThreadPoolExecutor)NettyServer.this.standardThreadExecutor));
            }
        });
        serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)true);
        serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)true);
        ChannelFuture channelFuture = serverBootstrap.bind((SocketAddress)new InetSocketAddress(this.url.getPort()));
        channelFuture.syncUninterruptibly();
        this.serverChannel = channelFuture.channel();
        this.state = ChannelState.ALIVE;
        StatsUtil.registryStatisticCallback((StatisticCallback)this);
        LoggerUtil.info((String)("NettyServer ServerChannel finish Open: url=" + this.url));
        return this.state.isAliveState();
    }

    public synchronized void close() {
        this.close(0);
    }

    public synchronized void close(int timeout) {
        if (this.state.isCloseState()) {
            LoggerUtil.info((String)"NettyServer close fail: already close, url={}", (Object[])new Object[]{this.url.getUri()});
            return;
        }
        if (this.state.isUnInitState()) {
            LoggerUtil.info((String)"NettyServer close Fail: don't need to close because node is unInit state: url={}", (Object[])new Object[]{this.url.getUri()});
            return;
        }
        try {
            if (this.serverChannel != null) {
                this.serverChannel.close();
                this.bossGroup.shutdownGracefully();
                this.workerGroup.shutdownGracefully();
                this.bossGroup = null;
                this.workerGroup = null;
            }
            if (this.channelManage != null) {
                this.channelManage.close();
            }
            if (this.standardThreadExecutor != null) {
                this.standardThreadExecutor.shutdownNow();
            }
            this.state = ChannelState.CLOSE;
            StatsUtil.unRegistryStatisticCallback((StatisticCallback)this);
            LoggerUtil.info((String)"NettyServer close Success: url={}", (Object[])new Object[]{this.url.getUri()});
        }
        catch (Exception e) {
            LoggerUtil.error((String)("NettyServer close Error: url=" + this.url.getUri()), (Throwable)e);
        }
    }

    public boolean isClosed() {
        return this.state.isCloseState();
    }

    public boolean isAvailable() {
        return this.state.isAliveState();
    }

    public URL getUrl() {
        return this.url;
    }

    public String statisticCallback() {
        return String.format("identity: %s connectionCount: %s taskCount: %s queueCount: %s maxThreadCount: %s maxTaskCount: %s", this.url.getIdentity(), this.channelManage.getChannels().size(), this.standardThreadExecutor.getSubmittedTasksCount(), this.standardThreadExecutor.getQueue().size(), this.standardThreadExecutor.getMaximumPoolSize(), this.standardThreadExecutor.getMaxSubmittedTaskCount());
    }
}

