/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.util.LoggerUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class NettyServerChannelManage
extends ChannelInboundHandlerAdapter {
    private ConcurrentMap<String, Channel> channels = new ConcurrentHashMap<String, Channel>();
    private int maxChannel = 0;

    public NettyServerChannelManage(int maxChannel) {
        this.maxChannel = maxChannel;
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        String channelKey = this.getChannelKey((InetSocketAddress)channel.localAddress(), (InetSocketAddress)channel.remoteAddress());
        if (this.channels.size() >= this.maxChannel) {
            LoggerUtil.warn((String)"NettyServerChannelManage channelConnected channel size out of limit: limit={} current={}", (Object[])new Object[]{this.maxChannel, this.channels.size()});
            channel.close();
        } else {
            this.channels.put(channelKey, channel);
            ctx.fireChannelRegistered();
        }
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        Channel channel = ctx.channel();
        String channelKey = this.getChannelKey((InetSocketAddress)channel.localAddress(), (InetSocketAddress)channel.remoteAddress());
        this.channels.remove(channelKey);
        ctx.fireChannelUnregistered();
    }

    public Map<String, Channel> getChannels() {
        return this.channels;
    }

    public void close() {
        for (Map.Entry entry : this.channels.entrySet()) {
            try {
                Channel channel = (Channel)entry.getValue();
                if (channel == null) continue;
                channel.close();
            }
            catch (Exception e) {
                LoggerUtil.error((String)("NettyServerChannelManage close channel Error: " + (String)entry.getKey()), (Throwable)e);
            }
        }
    }

    private String getChannelKey(InetSocketAddress local, InetSocketAddress remote) {
        String key = "";
        key = local == null || local.getAddress() == null ? key + "null-" : key + local.getAddress().getHostAddress() + ":" + local.getPort() + "-";
        key = remote == null || remote.getAddress() == null ? key + "null" : key + remote.getAddress().getHostAddress() + ":" + remote.getPort();
        return key;
    }
}

