/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.yar.yarclient;

import com.weibo.yar.YarException;
import com.weibo.yar.YarProtocol;
import com.weibo.yar.YarRequest;
import com.weibo.yar.YarResponse;
import com.weibo.yar.yarclient.YarClient;
import java.io.IOException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractYarClient
implements YarClient {
    protected String packageName = "JSON";

    @Override
    public <E> E call(String path, String method, Class<E> responseClass, Object ... parameterObject) throws IOException {
        return this.call(path, method, this.packageName, responseClass, parameterObject);
    }

    @Override
    public <E> E call(String path, String method, String packageName, Class<E> responseClass, Object ... parameterObject) throws IOException {
        byte[] requestBytes = this.buildRequestBtyes(this.generateId(), path, method, packageName, parameterObject);
        byte[] responseBytes = this.httpPost(path, null, requestBytes);
        E value = this.buildResponse(responseBytes, responseClass);
        return value;
    }

    protected byte[] buildRequestBtyes(String path, String method, String packageName, Object ... parameterObject) throws IOException {
        return this.buildRequestBtyes(this.generateId(), path, method, packageName, parameterObject);
    }

    protected byte[] buildRequestBtyes(long id, String path, String method, String packageName, Object ... parameterObject) throws IOException {
        YarRequest yarRequest = new YarRequest(id, packageName, method, parameterObject);
        return YarProtocol.toProtocolBytes(yarRequest);
    }

    protected <E> E buildResponse(byte[] responseBytes, Class<E> responseClass) throws IOException {
        YarResponse yarResponse = YarProtocol.buildResponse(responseBytes);
        if (yarResponse == null || yarResponse.getError() != null) {
            throw new YarException(yarResponse == null ? "yar response is null" : yarResponse.getError());
        }
        E value = yarResponse.getValue(responseClass);
        return value;
    }

    protected abstract byte[] httpPost(String var1, Map<String, String> var2, byte[] var3);

    protected long generateId() {
        return System.currentTimeMillis();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }
}

