/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class ZipCycleInputStream
extends InputStream {
    private final ZipInputStream zipInputStream;
    private ZipEntry currentZipEntry;

    public ZipCycleInputStream(InputStream in) {
        this.zipInputStream = new ZipInputStream(in);
    }

    @Override
    public int read() throws IOException {
        if (null == this.currentZipEntry) {
            this.currentZipEntry = this.zipInputStream.getNextEntry();
            if (null == this.currentZipEntry) {
                return -1;
            }
        }
        if (this.currentZipEntry.isDirectory()) {
            this.currentZipEntry = null;
            return this.read();
        }
        int result = this.zipInputStream.read();
        if (-1 == result) {
            this.currentZipEntry = null;
            return this.read();
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.zipInputStream.close();
    }
}

