/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;

public class BoolColumn
extends Column {
    public BoolColumn(Boolean bool) {
        super(bool, Column.Type.BOOL, 1);
    }

    public BoolColumn(String data) {
        this(true);
        this.validate(data);
        if (null == data) {
            this.setRawData(null);
            this.setByteSize(0);
        } else {
            this.setRawData(Boolean.valueOf(data));
            this.setByteSize(1);
        }
    }

    public BoolColumn() {
        super(null, Column.Type.BOOL, 1);
    }

    @Override
    public Boolean asBoolean() {
        if (null == super.getRawData()) {
            return null;
        }
        return (Boolean)super.getRawData();
    }

    @Override
    public Long asLong() {
        if (null == this.getRawData()) {
            return null;
        }
        return Boolean.TRUE.equals(this.asBoolean()) ? 1L : 0L;
    }

    @Override
    public Double asDouble() {
        if (null == this.getRawData()) {
            return null;
        }
        return Boolean.TRUE.equals(this.asBoolean()) ? 1.0 : 0.0;
    }

    @Override
    public String asString() {
        if (null == super.getRawData()) {
            return null;
        }
        return Boolean.TRUE.equals(this.asBoolean()) ? "true" : "false";
    }

    @Override
    public BigInteger asBigInteger() {
        if (null == this.getRawData()) {
            return null;
        }
        return BigInteger.valueOf(this.asLong());
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (null == this.getRawData()) {
            return null;
        }
        return BigDecimal.valueOf(this.asLong());
    }

    @Override
    public Date asDate() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bool type cannot be converted to Date.");
    }

    @Override
    public byte[] asBytes() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bool type cannot be converted to Bytes.");
    }

    @Override
    public Timestamp asTimestamp() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bool type cannot be converted to Timestamp.");
    }

    private void validate(String data) {
        if (null == data) {
            return;
        }
        if ("true".equalsIgnoreCase(data) || "false".equalsIgnoreCase(data)) {
            return;
        }
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String [%s] cannot be converted to Bool .", data));
    }
}

