/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.ColumnCast;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;
import org.apache.commons.lang3.ArrayUtils;

public class BytesColumn
extends Column {
    public BytesColumn() {
        this(null);
    }

    public BytesColumn(byte[] bytes) {
        super(ArrayUtils.clone((byte[])bytes), Column.Type.BYTES, null == bytes ? 0 : bytes.length);
    }

    @Override
    public byte[] asBytes() {
        if (null == this.getRawData()) {
            return new byte[0];
        }
        return (byte[])this.getRawData();
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        try {
            return ColumnCast.bytes2String(this);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Bytes[%s] cannot be converted to String .", this.toString()));
        }
    }

    @Override
    public Long asLong() {
        long value = 0L;
        for (byte b : this.asBytes()) {
            value = (value << 8) + (long)(b & 0xFF);
        }
        return value;
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes type cannot converted to BigDecimal.");
    }

    @Override
    public BigInteger asBigInteger() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes type cannot converted to BigInteger.");
    }

    @Override
    public Timestamp asTimestamp() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes type cannot converted to Timestamp.");
    }

    @Override
    public Double asDouble() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes type cannot converted to Long.");
    }

    @Override
    public Date asDate() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes type cannot converted to Date.");
    }

    @Override
    public Boolean asBoolean() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "Bytes type cannot converted to Boolean.");
    }
}

