/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.OverFlowUtil;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;

public class DoubleColumn
extends Column {
    private final String errorTemplate = "Double type cannot be converted to %s.";

    public DoubleColumn(String data) {
        this(data, null == data ? 0 : data.length());
        this.validate(data);
    }

    public DoubleColumn(Long data) {
        this(data == null ? null : String.valueOf(data));
    }

    public DoubleColumn(Integer data) {
        this(data == null ? null : String.valueOf(data));
    }

    public DoubleColumn(Double data) {
        this(data == null ? null : new BigDecimal(String.valueOf(data)).toPlainString());
    }

    public DoubleColumn(Float data) {
        this(data == null ? null : new BigDecimal(String.valueOf(data)).toPlainString());
    }

    public DoubleColumn(BigDecimal data) {
        this(null == data ? null : data.toPlainString());
    }

    public DoubleColumn(BigInteger data) {
        this(null == data ? null : data.toString());
    }

    public DoubleColumn() {
        this((String)null);
    }

    private DoubleColumn(String data, int byteSize) {
        super(data, Column.Type.DOUBLE, byteSize);
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (null == this.getRawData()) {
            return null;
        }
        try {
            return new BigDecimal((String)this.getRawData());
        }
        catch (NumberFormatException e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[%s] cannot be converted to Double.", this.getRawData()));
        }
    }

    @Override
    public Double asDouble() {
        boolean isDoubleSpecific;
        if (null == this.getRawData()) {
            return null;
        }
        String string = (String)this.getRawData();
        boolean bl = isDoubleSpecific = "NaN".equals(string) || "-Infinity".equals(string) || "+Infinity".equals(string);
        if (isDoubleSpecific) {
            return Double.valueOf(string);
        }
        BigDecimal result = this.asBigDecimal();
        OverFlowUtil.validateDoubleNotOverFlow(result);
        return result.doubleValue();
    }

    @Override
    public Long asLong() {
        if (null == this.getRawData()) {
            return null;
        }
        BigDecimal result = this.asBigDecimal();
        OverFlowUtil.validateLongNotOverFlow(result.toBigInteger());
        return result.longValue();
    }

    @Override
    public BigInteger asBigInteger() {
        if (null == this.getRawData()) {
            return null;
        }
        return this.asBigDecimal().toBigInteger();
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        return (String)this.getRawData();
    }

    @Override
    public Boolean asBoolean() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Double type cannot be converted to %s.", "Boolean"));
    }

    @Override
    public Date asDate() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Double type cannot be converted to %s.", "Date"));
    }

    @Override
    public byte[] asBytes() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Double type cannot be converted to %s.", "Bytes"));
    }

    @Override
    public Timestamp asTimestamp() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Double type cannot be converted to %s.", "Timestamp"));
    }

    private void validate(String data) {
        if (null == data) {
            return;
        }
        if ("NaN".equalsIgnoreCase(data) || "-Infinity".equalsIgnoreCase(data) || "Infinity".equalsIgnoreCase(data)) {
            return;
        }
        try {
            new BigDecimal(data);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String[%s] cannot be converted to Double.", data));
        }
    }
}

