/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;

public final class OverFlowUtil {
    public static final BigInteger MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    public static final BigInteger MIN_LONG = BigInteger.valueOf(Long.MIN_VALUE);
    public static final BigDecimal MIN_DOUBLE_POSITIVE = new BigDecimal(String.valueOf(Double.MIN_VALUE));
    public static final BigDecimal MAX_DOUBLE_POSITIVE = new BigDecimal(String.valueOf(Double.MAX_VALUE));

    private OverFlowUtil() {
    }

    public static boolean isLongOverflow(BigInteger integer) {
        return integer.compareTo(MAX_LONG) > 0 || integer.compareTo(MIN_LONG) < 0;
    }

    public static void validateLongNotOverFlow(BigInteger integer) {
        boolean isOverFlow = OverFlowUtil.isLongOverflow(integer);
        if (isOverFlow) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_OVER_FLOW, String.format("An overflow occurred when converting [%s] to Long type.", integer));
        }
    }

    public static boolean isDoubleOverFlow(BigDecimal decimal) {
        boolean isPositive;
        if (decimal.signum() == 0) {
            return false;
        }
        BigDecimal newDecimal = decimal;
        boolean bl = isPositive = decimal.signum() == 1;
        if (!isPositive) {
            newDecimal = decimal.negate();
        }
        return newDecimal.compareTo(MIN_DOUBLE_POSITIVE) < 0 || newDecimal.compareTo(MAX_DOUBLE_POSITIVE) > 0;
    }

    public static void validateDoubleNotOverFlow(BigDecimal decimal) {
        boolean isOverFlow = OverFlowUtil.isDoubleOverFlow(decimal);
        if (isOverFlow) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_OVER_FLOW, String.format("An overflow occurred when converting [%s] to Double type.", decimal.toPlainString()));
        }
    }
}

