/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.element.StringColumn;
import com.wgzhao.addax.common.util.Configuration;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import org.apache.commons.lang3.time.FastDateFormat;

class StringCast {
    static String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
    static String dateFormat = "yyyy-MM-dd";
    static String timeFormat = "HH:mm:ss";
    static List<String> extraFormats = Collections.emptyList();
    static String timeZone = "GMT+8";
    static FastDateFormat dateFormatter;
    static FastDateFormat timeFormatter;
    static FastDateFormat datetimeFormatter;
    static TimeZone timeZoner;
    static String encoding;

    private StringCast() {
    }

    static void init(Configuration configuration) {
        datetimeFormat = configuration.getString("common.column.datetimeFormat", datetimeFormat);
        dateFormat = configuration.getString("common.column.dateFormat", dateFormat);
        timeFormat = configuration.getString("common.column.timeFormat", timeFormat);
        extraFormats = configuration.getList("common.column.extraFormats", Collections.emptyList(), String.class);
        timeZone = configuration.getString("common.column.timeZone", timeZone);
        timeZoner = TimeZone.getTimeZone(timeZone);
        datetimeFormatter = FastDateFormat.getInstance((String)datetimeFormat, (TimeZone)timeZoner);
        dateFormatter = FastDateFormat.getInstance((String)dateFormat, (TimeZone)timeZoner);
        timeFormatter = FastDateFormat.getInstance((String)timeFormat, (TimeZone)timeZoner);
        encoding = configuration.getString("common.column.encoding", encoding);
    }

    static Date asDate(StringColumn column) throws ParseException {
        if (null == column.asString()) {
            return null;
        }
        try {
            return datetimeFormatter.parse(column.asString());
        }
        catch (ParseException parseException) {
            try {
                return dateFormatter.parse(column.asString());
            }
            catch (ParseException parseException2) {
                try {
                    return timeFormatter.parse(column.asString());
                }
                catch (ParseException pe) {
                    ParseException e = pe;
                    for (String format : extraFormats) {
                        try {
                            return FastDateFormat.getInstance((String)format, (TimeZone)timeZoner).parse(column.asString());
                        }
                        catch (ParseException pe2) {
                            e = pe2;
                        }
                    }
                    throw e;
                }
            }
        }
    }

    static byte[] asBytes(StringColumn column) throws UnsupportedEncodingException {
        if (null == column.asString()) {
            return new byte[0];
        }
        return column.asString().getBytes(encoding);
    }

    static {
        encoding = "UTF-8";
    }
}

