/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.util;

import java.io.InputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HostUtils {
    public static final String IP;
    public static final String HOSTNAME;
    private static final Logger log;
    private static final String UNKNOWN = "UNKNOWN";

    private HostUtils() {
    }

    static {
        log = LoggerFactory.getLogger(HostUtils.class);
        String ip = UNKNOWN;
        String hostname = UNKNOWN;
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            ip = inetAddress.getHostAddress();
            hostname = inetAddress.getHostName();
        }
        catch (UnknownHostException e) {
            log.error("Can't find out address: {}", (Object)e.getMessage());
        }
        if (ip.equals("127.0.0.1") || ip.equals("::1") || ip.equals(UNKNOWN)) {
            try {
                Process process = Runtime.getRuntime().exec("hostname -i");
                if (process.waitFor() == 0) {
                    ip = new String(IOUtils.toByteArray((InputStream)process.getInputStream()), StandardCharsets.UTF_8);
                }
                process.destroy();
                process = Runtime.getRuntime().exec("hostname");
                if (process.waitFor() == 0) {
                    hostname = new String(IOUtils.toByteArray((InputStream)process.getInputStream()), StandardCharsets.UTF_8).trim();
                }
                process.destroy();
            }
            catch (Exception e) {
                log.warn("Failed to get hostname: {}", (Object)e.getMessage());
            }
        }
        IP = ip;
        HOSTNAME = hostname;
        log.info("IP {} HOSTNAME {}", (Object)IP, (Object)HOSTNAME);
    }
}

