/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.util;

import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RetryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(RetryUtil.class);
    private static final long MAX_SLEEP_MILLISECOND = 256000L;

    private RetryUtil() {
    }

    public static <T> T executeWithRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential) throws Exception {
        Retry retry = new Retry();
        return retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, exponential, null);
    }

    public static <T> T executeWithRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, List<Class<?>> retryExceptionClass) throws Exception {
        Retry retry = new Retry();
        return retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, exponential, retryExceptionClass);
    }

    public static <T> T asyncExecuteWithRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, long timeoutMs, ThreadPoolExecutor executor) throws Exception {
        AsyncRetry retry = new AsyncRetry(timeoutMs, executor);
        return retry.doRetry(callable, retryTimes, sleepTimeInMilliSecond, exponential, null);
    }

    public static ThreadPoolExecutor createThreadPoolExecutor() {
        return new ThreadPoolExecutor(0, 5, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }

    private static class AsyncRetry
    extends Retry {
        private final long timeoutMs;
        private final ThreadPoolExecutor executor;

        public AsyncRetry(long timeoutMs, ThreadPoolExecutor executor) {
            this.timeoutMs = timeoutMs;
            this.executor = executor;
        }

        @Override
        protected <T> T call(Callable<T> callable) throws Exception {
            Future<T> future = this.executor.submit(callable);
            try {
                T t = future.get(this.timeoutMs, TimeUnit.MILLISECONDS);
                return t;
            }
            catch (Exception e) {
                throw e;
            }
            finally {
                if (!future.isDone()) {
                    future.cancel(true);
                    LOG.warn("A try-once task was not completed. Cancel it. Active count: {}.", (Object)this.executor.getActiveCount());
                }
            }
        }
    }

    private static class Retry {
        private Retry() {
        }

        public <T> T doRetry(Callable<T> callable, int retryTimes, long sleepTimeInMilliSecond, boolean exponential, List<Class<?>> retryExceptionClass) throws Exception {
            if (null == callable) {
                throw new IllegalArgumentException("The parameter callable cannot be null.");
            }
            if (retryTimes < 1) {
                throw new IllegalArgumentException(String.format("The value [%d] of parameter retryTime cannot less than 1", retryTimes));
            }
            Exception saveException = null;
            for (int i = 0; i < retryTimes; ++i) {
                try {
                    return this.call(callable);
                }
                catch (Exception e) {
                    saveException = e;
                    if (null != retryExceptionClass && !retryExceptionClass.isEmpty()) {
                        boolean needRetry = false;
                        for (Class<?> eachExceptionClass : retryExceptionClass) {
                            if (eachExceptionClass != e.getClass()) continue;
                            needRetry = true;
                            break;
                        }
                        if (!needRetry) {
                            throw saveException;
                        }
                    }
                    if (i + 1 >= retryTimes || sleepTimeInMilliSecond <= 0L) continue;
                    long startTime = System.currentTimeMillis();
                    long timeToSleep = exponential ? sleepTimeInMilliSecond * (long)Math.pow(2.0, i) : sleepTimeInMilliSecond;
                    if (timeToSleep >= 256000L) {
                        timeToSleep = 256000L;
                    }
                    try {
                        Thread.sleep(timeToSleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    long realTimeSleep = System.currentTimeMillis() - startTime;
                    LOG.error("Exception when calling callable, Attempt retry {}. This retry waits {}ms, actually waits {}ms, exception message: {}.", new Object[]{i + 1, timeToSleep, realTimeSleep, e.getMessage()});
                    continue;
                }
            }
            throw saveException;
        }

        protected <T> T call(Callable<T> callable) throws Exception {
            return callable.call();
        }
    }
}

