/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.compress;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.Adler32;
import java.util.zip.CRC32;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.anarres.lzo.LzopInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExpandLzopInputStream
extends LzopInputStream {
    public ExpandLzopInputStream(@Nonnull InputStream in) throws IOException {
        super(in);
    }

    protected int readHeader() throws IOException {
        boolean extraField;
        int lzoLibraryVersion = 8288;
        Log log = LogFactory.getLog(LzopInputStream.class);
        byte[] lzopMagic = new byte[]{-119, 76, 90, 79, 0, 13, 10, 26, 10};
        byte[] buf = new byte[9];
        this.readBytes(buf, 0, 9);
        if (!Arrays.equals(buf, lzopMagic)) {
            throw new IOException("Invalid LZO header");
        }
        Arrays.fill(buf, (byte)0);
        Adler32 adler = new Adler32();
        CRC32 crc32 = new CRC32();
        int hitem = this.readHeaderItem(buf, 2, adler, crc32);
        if (hitem > 4112) {
            log.debug((Object)("Compressed with later version of lzop: " + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(4112) + ")"));
        }
        if ((hitem = this.readHeaderItem(buf, 2, adler, crc32)) > lzoLibraryVersion) {
            throw new IOException("Compressed with incompatible lzo version: 0x" + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(8272) + ")");
        }
        hitem = this.readHeaderItem(buf, 2, adler, crc32);
        if (hitem > 4112) {
            throw new IOException("Compressed with incompatible lzop version: 0x" + Integer.toHexString(hitem) + " (expected 0x" + Integer.toHexString(4112) + ")");
        }
        hitem = this.readHeaderItem(buf, 1, adler, crc32);
        switch (hitem) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IOException("Invalid strategy " + Integer.toHexString(hitem));
            }
        }
        this.readHeaderItem(buf, 1, adler, crc32);
        int flags = this.readHeaderItem(buf, 4, adler, crc32);
        boolean useCRC32 = ((long)flags & 0x1000L) != 0L;
        boolean bl = extraField = ((long)flags & 0x40L) != 0L;
        if (((long)flags & 0x400L) != 0L) {
            throw new IOException("Multipart lzop not supported");
        }
        if (((long)flags & 0x800L) != 0L) {
            throw new IOException("lzop filter not supported");
        }
        if (((long)flags & 0xFC000L) != 0L) {
            throw new IOException("Unknown flags in header");
        }
        this.readHeaderItem(buf, 4, adler, crc32);
        this.readHeaderItem(buf, 4, adler, crc32);
        this.readHeaderItem(buf, 4, adler, crc32);
        hitem = this.readHeaderItem(buf, 1, adler, crc32);
        if (hitem > 0) {
            byte[] tmp = hitem > buf.length ? new byte[hitem] : buf;
            this.readHeaderItem(tmp, hitem, adler, crc32);
        }
        int checksum = (int)(useCRC32 ? crc32.getValue() : adler.getValue());
        hitem = this.readHeaderItem(buf, 4, adler, crc32);
        if (hitem != checksum) {
            throw new IOException("Invalid header checksum: " + Long.toHexString(checksum) + " (expected 0x" + Integer.toHexString(hitem) + ")");
        }
        if (extraField) {
            log.debug((Object)"Extra header field not processed");
            adler.reset();
            crc32.reset();
            hitem = this.readHeaderItem(buf, 4, adler, crc32);
            this.readHeaderItem(new byte[hitem], hitem, adler, crc32);
            checksum = (int)(useCRC32 ? crc32.getValue() : adler.getValue());
            if (checksum != this.readHeaderItem(buf, 4, adler, crc32)) {
                throw new IOException("Invalid checksum for extra header field");
            }
        }
        return flags;
    }

    private int readHeaderItem(@Nonnull byte[] buf, @Nonnegative int len, @Nonnull Adler32 adler, @Nonnull CRC32 crc32) throws IOException {
        int ret = this.readInt(buf, len);
        adler.update(buf, 0, len);
        crc32.update(buf, 0, len);
        Arrays.fill(buf, (byte)0);
        return ret;
    }

    private int readInt(@Nonnull byte[] buf, @Nonnegative int len) throws IOException {
        this.readBytes(buf, 0, len);
        int ret = (0xFF & buf[0]) << 24;
        ret |= (0xFF & buf[1]) << 16;
        ret |= (0xFF & buf[2]) << 8;
        return len > 3 ? ret : (ret |= 0xFF & buf[3]) >>> 8 * (4 - len);
    }
}

