/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.element.DateColumn;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.util.Configuration;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;

class DateCast {
    static String datetimeFormat = "yyyy-MM-dd HH:mm:ss";
    static String dateFormat = "yyyy-MM-dd";
    static String timeFormat = "HH:mm:ss";
    static String timeZone = "GMT+8";
    static TimeZone timeZoner = TimeZone.getTimeZone(timeZone);

    private DateCast() {
    }

    static void init(Configuration configuration) {
        datetimeFormat = configuration.getString("common.column.datetimeFormat", datetimeFormat);
        timeFormat = configuration.getString("common.column.timeFormat", timeFormat);
        dateFormat = configuration.getString("common.column.dateFormat", dateFormat);
        timeZone = configuration.getString("common.column.timeZone", timeZone);
        timeZoner = TimeZone.getTimeZone(timeZone);
    }

    static String asString(DateColumn column) {
        if (null == column.asDate()) {
            return null;
        }
        switch (column.getSubType()) {
            case DATE: {
                return DateFormatUtils.format((Date)column.asDate(), (String)dateFormat, (TimeZone)timeZoner);
            }
            case TIME: {
                return DateFormatUtils.format((Date)column.asDate(), (String)timeFormat, (TimeZone)timeZoner);
            }
            case DATETIME: {
                return DateFormatUtils.format((Date)column.asDate(), (String)datetimeFormat, (TimeZone)timeZoner);
            }
        }
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, "An unsupported type occurred for the date type. Currently, only DATE/TIME/DATETIME are supported.");
    }
}

