/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.ColumnCast;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;

public class DateColumn
extends Column {
    private DateType subType = DateType.DATETIME;
    private int nanos = 0;
    private int precision = -1;
    private final String errorTemplate = "Date type cannot be converted to %s.";

    public DateColumn() {
        this((Long)null);
    }

    public DateColumn(Long stamp) {
        super(stamp, Column.Type.DATE, null == stamp ? 0 : 8);
    }

    public DateColumn(Date date) {
        this(date == null ? null : Long.valueOf(date.getTime()));
    }

    public DateColumn(java.sql.Date date) {
        this(date == null ? null : Long.valueOf(date.getTime()));
        this.setSubType(DateType.DATE);
    }

    public DateColumn(Time time) {
        this(time == null ? null : Long.valueOf(time.getTime()));
        this.setSubType(DateType.TIME);
    }

    public DateColumn(Timestamp ts) {
        this(ts == null ? null : Long.valueOf(ts.getTime()));
        this.setSubType(DateType.DATETIME);
    }

    public DateColumn(Time time, int nanos, int jdbcPrecision) {
        this(time);
        if (time != null) {
            this.setNanos(nanos);
        }
        if (jdbcPrecision == 10) {
            this.setPrecision(0);
        }
        if (jdbcPrecision >= 12 && jdbcPrecision <= 17) {
            this.setPrecision(jdbcPrecision - 11);
        }
    }

    public long getNanos() {
        return this.nanos;
    }

    public void setNanos(int nanos) {
        this.nanos = nanos;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public Long asLong() {
        return (Long)this.getRawData();
    }

    @Override
    public String asString() {
        try {
            return ColumnCast.date2String(this);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date[%s] type cannot be converted to String .", this));
        }
    }

    @Override
    public Date asDate() {
        if (null == this.getRawData()) {
            return null;
        }
        return new Date((Long)this.getRawData());
    }

    @Override
    public byte[] asBytes() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date type cannot be converted to %s.", "Bytes"));
    }

    @Override
    public Boolean asBoolean() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date type cannot be converted to %s.", "Boolean"));
    }

    @Override
    public Double asDouble() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date type cannot be converted to %s.", "Double"));
    }

    @Override
    public BigInteger asBigInteger() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date type cannot be converted to %s.", "BigInteger"));
    }

    @Override
    public Timestamp asTimestamp() {
        if (null == this.getRawData()) {
            return null;
        }
        return new Timestamp(this.asLong());
    }

    @Override
    public BigDecimal asBigDecimal() {
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("Date type cannot be converted to %s.", "BigDecimal"));
    }

    public DateType getSubType() {
        return this.subType;
    }

    public void setSubType(DateType subType) {
        this.subType = subType;
    }

    public static enum DateType {
        DATE,
        TIME,
        DATETIME;

    }
}

