/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.element;

import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.ColumnCast;
import com.wgzhao.addax.common.element.OverFlowUtil;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.Date;

public class StringColumn
extends Column {
    private final String errorTemplate = "String type cannot be converted to %s.";

    public StringColumn() {
        this(null);
    }

    public StringColumn(String rawData) {
        super(rawData, Column.Type.STRING, null == rawData ? 0 : rawData.length());
    }

    @Override
    public String asString() {
        if (null == this.getRawData()) {
            return null;
        }
        return (String)this.getRawData();
    }

    private void validateDoubleSpecific(String data) {
        if ("NaN".equals(data) || "Infinity".equals(data) || "-Infinity".equals(data)) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("['%s'] belongs to the special Double type and cannot be converted to other type.", data));
        }
    }

    @Override
    public BigInteger asBigInteger() {
        if (null == this.getRawData()) {
            return null;
        }
        this.validateDoubleSpecific((String)this.getRawData());
        try {
            return this.asBigDecimal().toBigInteger();
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("['%s'] cannot be converted to BigInteger.", this.asString()));
        }
    }

    @Override
    public Timestamp asTimestamp() {
        if (null == this.getRawData()) {
            return null;
        }
        return Timestamp.valueOf((String)this.getRawData());
    }

    @Override
    public Long asLong() {
        if (null == this.getRawData()) {
            return null;
        }
        this.validateDoubleSpecific((String)this.getRawData());
        try {
            BigInteger integer = this.asBigInteger();
            OverFlowUtil.validateLongNotOverFlow(integer);
            return integer.longValue();
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String type cannot be converted to %s.", "Long"));
        }
    }

    @Override
    public BigDecimal asBigDecimal() {
        if (null == this.getRawData()) {
            return null;
        }
        this.validateDoubleSpecific((String)this.getRawData());
        try {
            return new BigDecimal(this.asString());
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String type cannot be converted to %s.", "BigDecimal"));
        }
    }

    @Override
    public Double asDouble() {
        if (null == this.getRawData()) {
            return null;
        }
        String data = (String)this.getRawData();
        if ("NaN".equals(data)) {
            return Double.NaN;
        }
        if ("Infinity".equals(data)) {
            return Double.POSITIVE_INFINITY;
        }
        if ("-Infinity".equals(data)) {
            return Double.NEGATIVE_INFINITY;
        }
        BigDecimal decimal = this.asBigDecimal();
        OverFlowUtil.validateDoubleNotOverFlow(decimal);
        return decimal.doubleValue();
    }

    @Override
    public Boolean asBoolean() {
        if (null == this.getRawData()) {
            return null;
        }
        if ("true".equalsIgnoreCase(this.asString())) {
            return true;
        }
        if ("false".equalsIgnoreCase(this.asString())) {
            return false;
        }
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String type cannot be converted to %s.", "Boolean"));
    }

    @Override
    public Date asDate() {
        try {
            return ColumnCast.string2Date(this);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String type cannot be converted to %s.", "Date"));
        }
    }

    @Override
    public byte[] asBytes() {
        try {
            return ColumnCast.string2Bytes(this);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONVERT_NOT_SUPPORT, String.format("String type cannot be converted to %s.", "Bytes"));
        }
    }
}

