/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.statistics;

import com.wgzhao.addax.common.util.HostUtils;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.time.DateFormatUtils;

public class PerfRecord
implements Comparable<PerfRecord> {
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final int taskGroupId;
    private final int taskId;
    private final PHASE phase;
    private volatile Date startTime;
    private final long elapsedTimeInNs = -1L;
    private volatile long count = 0L;
    private volatile long size = 0L;

    public PerfRecord(int taskGroupId, int taskId, PHASE phase) {
        this.taskGroupId = taskGroupId;
        this.taskId = taskId;
        this.phase = phase;
    }

    public void start() {
    }

    public void addCount(long count) {
        this.count += count;
    }

    public void addSize(long size) {
        this.size += size;
    }

    public void end() {
    }

    public void end(long elapsedTimeInNs) {
    }

    public String toString() {
        return String.format("%s,%s,%s,%s,%s,%s,%s,%s,%s", new Object[]{this.getInstId(), this.taskGroupId, this.taskId, this.phase, DateFormatUtils.format((Date)this.startTime, (String)DATETIME_FORMAT), -1L, this.count, this.size, this.getHostIP()});
    }

    @Override
    public int compareTo(PerfRecord o) {
        if (o == null) {
            return 1;
        }
        return Long.compare(this.elapsedTimeInNs, o.elapsedTimeInNs);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + this.taskGroupId;
        result = 31 * result + this.taskId;
        result = 31 * result + this.phase.toInt();
        result = 31 * result + (this.startTime != null ? this.startTime.hashCode() : 0);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PerfRecord)) {
            return false;
        }
        PerfRecord dst = (PerfRecord)o;
        if (this.getInstId() != dst.getInstId()) {
            return false;
        }
        if (this.taskGroupId != dst.taskGroupId) {
            return false;
        }
        if (this.taskId != dst.taskId) {
            return false;
        }
        if (!Objects.equals((Object)this.phase, (Object)dst.phase)) {
            return false;
        }
        return Objects.equals(this.startTime, dst.startTime);
    }

    public int getTaskGroupId() {
        return this.taskGroupId;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public PHASE getPhase() {
        return this.phase;
    }

    public long getCount() {
        return this.count;
    }

    public long getSize() {
        return this.size;
    }

    public long getInstId() {
        return 0L;
    }

    public String getHostIP() {
        return HostUtils.IP;
    }

    public static enum PHASE {
        TASK_TOTAL(0),
        READ_TASK_INIT(1),
        READ_TASK_PREPARE(2),
        READ_TASK_DATA(3),
        READ_TASK_POST(4),
        READ_TASK_DESTROY(5),
        WRITE_TASK_INIT(6),
        WRITE_TASK_PREPARE(7),
        WRITE_TASK_DATA(8),
        WRITE_TASK_POST(9),
        WRITE_TASK_DESTROY(10),
        SQL_QUERY(100),
        RESULT_NEXT_ALL(101),
        ODPS_BLOCK_CLOSE(102),
        WAIT_READ_TIME(103),
        WAIT_WRITE_TIME(104),
        TRANSFORMER_TIME(201);

        private final int val;

        private PHASE(int val) {
            this.val = val;
        }

        public int toInt() {
            return this.val;
        }
    }
}

