/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.statistics;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VMInfo {
    static final long MB = 0x100000L;
    static final long GB = 0x40000000L;
    private static final Logger LOG = LoggerFactory.getLogger(VMInfo.class);
    private static VMInfo vmInfo;
    private final OperatingSystemMXBean osMXBean;
    private final RuntimeMXBean runtimeMXBean;
    private final List<GarbageCollectorMXBean> garbageCollectorMXBeanList;
    private final List<MemoryPoolMXBean> memoryPoolMXBeanList;
    private final String osInfo;
    private final String jvmInfo;
    private final int totalProcessorCount;
    private final PhyOSStatus startPhyOSStatus;
    private final ProcessCpuStatus processCpuStatus = new ProcessCpuStatus();
    private final ProcessGCStatus processGCStatus = new ProcessGCStatus();
    private final ProcessMemoryStatus processMemoryStatus = new ProcessMemoryStatus();
    private long lastUpTime = 0L;
    private long lastProcessCpuTime = 0L;

    private VMInfo() {
        this.osMXBean = ManagementFactory.getOperatingSystemMXBean();
        this.runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        this.garbageCollectorMXBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        this.memoryPoolMXBeanList = ManagementFactory.getMemoryPoolMXBeans();
        this.jvmInfo = this.runtimeMXBean.getVmVendor() + " " + this.runtimeMXBean.getSpecVersion() + " " + this.runtimeMXBean.getVmVersion();
        this.osInfo = this.osMXBean.getName() + " " + this.osMXBean.getArch() + " " + this.osMXBean.getVersion();
        this.totalProcessorCount = this.osMXBean.getAvailableProcessors();
        this.startPhyOSStatus = new PhyOSStatus();
        LOG.info("VMInfo# operatingSystem class => {}", (Object)this.osMXBean.getClass().getName());
        if (VMInfo.isSunOsMBean(this.osMXBean)) {
            this.startPhyOSStatus.totalPhysicalMemory = VMInfo.getLongFromOperatingSystem(this.osMXBean, "getTotalPhysicalMemorySize");
            this.startPhyOSStatus.freePhysicalMemory = VMInfo.getLongFromOperatingSystem(this.osMXBean, "getFreePhysicalMemorySize");
            this.startPhyOSStatus.maxFileDescriptorCount = VMInfo.getLongFromOperatingSystem(this.osMXBean, "getMaxFileDescriptorCount");
            this.startPhyOSStatus.currentOpenFileDescriptorCount = VMInfo.getLongFromOperatingSystem(this.osMXBean, "getOpenFileDescriptorCount");
        }
        for (GarbageCollectorMXBean garbage : this.garbageCollectorMXBeanList) {
            GCStatus gcStatus = new GCStatus();
            gcStatus.name = garbage.getName();
            this.processGCStatus.gcStatusMap.put(garbage.getName(), gcStatus);
        }
        if (this.memoryPoolMXBeanList != null && !this.memoryPoolMXBeanList.isEmpty()) {
            for (MemoryPoolMXBean pool : this.memoryPoolMXBeanList) {
                MemoryStatus memoryStatus = new MemoryStatus();
                memoryStatus.name = pool.getName();
                memoryStatus.initSize = pool.getUsage().getInit();
                memoryStatus.maxSize = pool.getUsage().getMax();
                this.processMemoryStatus.memoryStatusMap.put(pool.getName(), memoryStatus);
            }
        }
    }

    public static synchronized VMInfo getVmInfo() {
        if (vmInfo == null) {
            vmInfo = new VMInfo();
        }
        return vmInfo;
    }

    public static boolean isSunOsMBean(OperatingSystemMXBean operatingSystem) {
        String className = operatingSystem.getClass().getName();
        return "com.sun.management.UnixOperatingSystem".equals(className);
    }

    public static long getLongFromOperatingSystem(OperatingSystemMXBean operatingSystem, String methodName) {
        try {
            Method method = operatingSystem.getClass().getMethod(methodName, null);
            method.setAccessible(true);
            return (Long)method.invoke((Object)operatingSystem, (Object[])null);
        }
        catch (Exception e) {
            LOG.info(String.format("OperatingSystemMXBean %s failed, Exception = %s ", methodName, e.getMessage()));
            return -1L;
        }
    }

    public String toString() {
        return "the machine info  => \n\n\tosInfo: \t" + this.osInfo + "\n\tjvmInfo:\t" + this.jvmInfo + "\n\tcpu num:\t" + this.totalProcessorCount + "\n\n" + this.startPhyOSStatus.toString() + "\n" + this.processGCStatus + "\n" + this.processMemoryStatus + "\n";
    }

    public String totalString() {
        return this.processCpuStatus.getTotalString() + this.processGCStatus.getTotalString();
    }

    public synchronized void getDelta(boolean print) {
        try {
            if (VMInfo.isSunOsMBean(this.osMXBean)) {
                long curUptime = this.runtimeMXBean.getUptime();
                long curProcessTime = VMInfo.getLongFromOperatingSystem(this.osMXBean, "getProcessCpuTime");
                if (curUptime > this.lastUpTime && curProcessTime >= this.lastProcessCpuTime) {
                    float curDeltaCpu = (float)(curProcessTime - this.lastProcessCpuTime) / (float)((curUptime - this.lastUpTime) * (long)this.totalProcessorCount * 10000L);
                    this.processCpuStatus.setMaxMinCpu(curDeltaCpu);
                    this.processCpuStatus.averageCpu = (float)curProcessTime / (float)(curUptime * (long)this.totalProcessorCount * 10000L);
                    this.lastUpTime = curUptime;
                    this.lastProcessCpuTime = curProcessTime;
                }
            }
            for (GarbageCollectorMXBean garbage : this.garbageCollectorMXBeanList) {
                GCStatus gcStatus = this.processGCStatus.gcStatusMap.get(garbage.getName());
                if (gcStatus == null) {
                    gcStatus = new GCStatus();
                    gcStatus.name = garbage.getName();
                    this.processGCStatus.gcStatusMap.put(garbage.getName(), gcStatus);
                }
                long curTotalGcCount = garbage.getCollectionCount();
                gcStatus.setCurTotalGcCount(curTotalGcCount);
                long curtotalGcTime = garbage.getCollectionTime();
                gcStatus.setCurTotalGcTime(curtotalGcTime);
            }
            if (this.memoryPoolMXBeanList != null && !this.memoryPoolMXBeanList.isEmpty()) {
                for (MemoryPoolMXBean pool : this.memoryPoolMXBeanList) {
                    MemoryStatus memoryStatus = this.processMemoryStatus.memoryStatusMap.get(pool.getName());
                    if (memoryStatus == null) {
                        memoryStatus = new MemoryStatus();
                        memoryStatus.name = pool.getName();
                        this.processMemoryStatus.memoryStatusMap.put(pool.getName(), memoryStatus);
                    }
                    memoryStatus.commitedSize = pool.getUsage().getCommitted();
                    memoryStatus.setMaxMinUsedSize(pool.getUsage().getUsed());
                    long maxMemory = memoryStatus.commitedSize > 0L ? memoryStatus.commitedSize : memoryStatus.maxSize;
                    memoryStatus.setMaxMinPercent(maxMemory > 0L ? 100.0f * (float)memoryStatus.usedSize / (float)maxMemory : -1.0f);
                }
            }
            if (print) {
                LOG.info(this.processCpuStatus.getDeltaString() + this.processMemoryStatus.getDeltaString() + this.processGCStatus.getDeltaString());
            }
        }
        catch (Exception e) {
            LOG.warn("no need care, the fail is ignored : vmInfo getDelta failed {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private class ProcessCpuStatus {
        float maxDeltaCpu = -1.0f;
        float minDeltaCpu = -1.0f;
        float curDeltaCpu = -1.0f;
        float averageCpu = -1.0f;

        private ProcessCpuStatus() {
        }

        public void setMaxMinCpu(float curCpu) {
            this.curDeltaCpu = curCpu;
            if (this.maxDeltaCpu < curCpu) {
                this.maxDeltaCpu = curCpu;
            }
            if (this.minDeltaCpu == -1.0f || this.minDeltaCpu > curCpu) {
                this.minDeltaCpu = curCpu;
            }
        }

        public String getDeltaString() {
            return "\n\t [delta cpu info] => \n\t\t" + String.format("%-30s | %-30s | %-30s | %-30s %n", "curDeltaCpu", "averageCpu", "maxDeltaCpu", "minDeltaCpu") + "\t\t" + String.format("%-30s | %-30s | %-30s | %-30s %n", String.format("%,.2f%%", Float.valueOf(((VMInfo)VMInfo.this).processCpuStatus.curDeltaCpu)), String.format("%,.2f%%", Float.valueOf(((VMInfo)VMInfo.this).processCpuStatus.averageCpu)), String.format("%,.2f%%", Float.valueOf(((VMInfo)VMInfo.this).processCpuStatus.maxDeltaCpu)), String.format("%,.2f%%%n", Float.valueOf(((VMInfo)VMInfo.this).processCpuStatus.minDeltaCpu)));
        }

        public String getTotalString() {
            return "\n\t [total cpu info] => \n\t\t" + String.format("%-30s | %-30s | %-30s %n", "averageCpu", "maxDeltaCpu", "minDeltaCpu") + "\t\t" + String.format("%-30s | %-30s | %-30s %n", String.format("%,.2f%%", Float.valueOf(((VMInfo)VMInfo.this).processCpuStatus.averageCpu)), String.format("%,.2f%%", Float.valueOf(((VMInfo)VMInfo.this).processCpuStatus.maxDeltaCpu)), String.format("%,.2f%%%n", Float.valueOf(((VMInfo)VMInfo.this).processCpuStatus.minDeltaCpu)));
        }
    }

    private static class MemoryStatus {
        String name;
        long initSize;
        long maxSize;
        long commitedSize;
        long usedSize;
        float percent;
        long maxUsedSize = -1L;
        float maxPercent = 0.0f;

        private MemoryStatus() {
        }

        void setMaxMinUsedSize(long curUsedSize) {
            if (this.maxUsedSize < curUsedSize) {
                this.maxUsedSize = curUsedSize;
            }
            this.usedSize = curUsedSize;
        }

        void setMaxMinPercent(float curPercent) {
            if (this.maxPercent < curPercent) {
                this.maxPercent = curPercent;
            }
            this.percent = curPercent;
        }
    }

    private static class GCStatus {
        String name;
        long maxDeltaGCCount = -1L;
        long minDeltaGCCount = -1L;
        long curDeltaGCCount;
        long totalGCCount = 0L;
        long maxDeltaGCTime = -1L;
        long minDeltaGCTime = -1L;
        long curDeltaGCTime;
        long totalGCTime = 0L;

        private GCStatus() {
        }

        public void setCurTotalGcCount(long curTotalGcCount) {
            this.curDeltaGCCount = curTotalGcCount - this.totalGCCount;
            this.totalGCCount = curTotalGcCount;
            if (this.maxDeltaGCCount < this.curDeltaGCCount) {
                this.maxDeltaGCCount = this.curDeltaGCCount;
            }
            if (this.minDeltaGCCount == -1L || this.minDeltaGCCount > this.curDeltaGCCount) {
                this.minDeltaGCCount = this.curDeltaGCCount;
            }
        }

        public void setCurTotalGcTime(long curTotalGcTime) {
            this.curDeltaGCTime = curTotalGcTime - this.totalGCTime;
            this.totalGCTime = curTotalGcTime;
            if (this.maxDeltaGCTime < this.curDeltaGCTime) {
                this.maxDeltaGCTime = this.curDeltaGCTime;
            }
            if (this.minDeltaGCTime == -1L || this.minDeltaGCTime > this.curDeltaGCTime) {
                this.minDeltaGCTime = this.curDeltaGCTime;
            }
        }
    }

    private static class ProcessMemoryStatus {
        final Map<String, MemoryStatus> memoryStatusMap = new HashMap<String, MemoryStatus>();

        private ProcessMemoryStatus() {
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\t");
            sb.append(String.format("%-30s | %-30s | %-30s %n", "MEMORY_NAME", "allocation_size", "init_size"));
            for (MemoryStatus ms : this.memoryStatusMap.values()) {
                sb.append("\t");
                sb.append(String.format("%-30s | %-30s | %-30s %n", ms.name, String.format("%,.2fMB", Float.valueOf((float)ms.maxSize / 1048576.0f)), String.format("%,.2fMB", Float.valueOf((float)ms.initSize / 1048576.0f))));
            }
            return sb.toString();
        }

        public String getDeltaString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\t [delta memory info] => \n");
            sb.append("\t\t ");
            sb.append(String.format("%-30s | %-30s | %-30s | %-30s | %-30s %n", "NAME", "used_size", "used_percent", "max_used_size", "max_percent"));
            for (MemoryStatus ms : this.memoryStatusMap.values()) {
                sb.append("\t\t ");
                sb.append(String.format("%-30s | %-30s | %-30s | %-30s | %-30s %n", ms.name, String.format("%,.2f", Float.valueOf((float)ms.usedSize / 1048576.0f)) + "MB", String.format("%,.2f", Float.valueOf(ms.percent)) + "%", String.format("%,.2f", Float.valueOf((float)ms.maxUsedSize / 1048576.0f)) + "MB", String.format("%,.2f", Float.valueOf(ms.maxPercent)) + "%"));
            }
            return sb.toString();
        }
    }

    private static class ProcessGCStatus {
        final Map<String, GCStatus> gcStatusMap = new HashMap<String, GCStatus>();

        private ProcessGCStatus() {
        }

        public String toString() {
            return "\tGC Names\t" + this.gcStatusMap.keySet() + "\n";
        }

        public String getDeltaString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\t [delta gc info] => \n");
            sb.append("\t\t ");
            sb.append(String.format("%-20s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s \n", "NAME", "curDeltaGCCount", "totalGCCount", "maxDeltaGCCount", "minDeltaGCCount", "curDeltaGCTime", "totalGCTime", "maxDeltaGCTime", "minDeltaGCTime"));
            for (GCStatus gc : this.gcStatusMap.values()) {
                sb.append("\t\t ");
                sb.append(String.format("%-20s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s %n", gc.name, gc.curDeltaGCCount, gc.totalGCCount, gc.maxDeltaGCCount, gc.minDeltaGCCount, String.format("%,.3fs", Float.valueOf((float)gc.curDeltaGCTime / 1000.0f)), String.format("%,.3fs", Float.valueOf((float)gc.totalGCTime / 1000.0f)), String.format("%,.3fs", Float.valueOf((float)gc.maxDeltaGCTime / 1000.0f)), String.format("%,.3fs", Float.valueOf((float)gc.minDeltaGCTime / 1000.0f))));
            }
            return sb.toString();
        }

        public String getTotalString() {
            StringBuilder sb = new StringBuilder();
            sb.append("\n\t [total gc info] => \n");
            sb.append("\t\t ");
            sb.append(String.format("%-20s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s %n", "NAME", "totalGCCount", "maxDeltaGCCount", "minDeltaGCCount", "totalGCTime", "maxDeltaGCTime", "minDeltaGCTime"));
            for (GCStatus gc : this.gcStatusMap.values()) {
                sb.append("\t\t ");
                sb.append(String.format("%-20s | %-18s | %-18s | %-18s | %-18s | %-18s | %-18s %n", gc.name, gc.totalGCCount, gc.maxDeltaGCCount, gc.minDeltaGCCount, String.format("%,.3fs", Float.valueOf((float)gc.totalGCTime / 1000.0f)), String.format("%,.3fs", Float.valueOf((float)gc.maxDeltaGCTime / 1000.0f)), String.format("%,.3fs", Float.valueOf((float)gc.minDeltaGCTime / 1000.0f))));
            }
            return sb.toString();
        }
    }

    private static class PhyOSStatus {
        long totalPhysicalMemory = -1L;
        long freePhysicalMemory = -1L;
        long maxFileDescriptorCount = -1L;
        long currentOpenFileDescriptorCount = -1L;

        private PhyOSStatus() {
        }

        public String toString() {
            return String.format("\ttotalPhysicalMemory:\t%,.2fG%n\tfreePhysicalMemory:\t%,.2fG%n\tmaxFileDescriptorCount:\t%s%n\tcurrentOpenFileDescriptorCount:\t%s%n", Float.valueOf((float)this.totalPhysicalMemory / 1.0737418E9f), Float.valueOf((float)this.freePhysicalMemory / 1.0737418E9f), this.maxFileDescriptorCount, this.currentOpenFileDescriptorCount);
        }
    }
}

