/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.util;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONWriter;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Configuration {
    private Set<String> secretKeyPathSet = new HashSet<String>();
    private Object root;

    private Configuration(String json) {
        try {
            this.root = JSON.parse((String)json);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("The configuration is incorrect. The configuration you provided is not in valid JSON format: %s.", e.getMessage()));
        }
    }

    public static Configuration newDefault() {
        return Configuration.from("{}");
    }

    public static Configuration from(String json) {
        json = StrUtil.replaceVariable(json);
        Configuration.checkJSON(json);
        try {
            return new Configuration(json);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, e);
        }
    }

    public static Configuration from(File file) {
        try {
            return Configuration.from(IOUtils.toString((InputStream)new FileInputStream(file), (Charset)StandardCharsets.UTF_8));
        }
        catch (FileNotFoundException e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("No such file: %s", file.getAbsolutePath()));
        }
        catch (IOException e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("Failed to read the configuration [%s], reason: %s.", file.getAbsolutePath(), e));
        }
    }

    public static Configuration from(InputStream is) {
        try {
            return Configuration.from(IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("Failed to read the configuration reason: %s.", e));
        }
    }

    public static Configuration from(Map<String, Object> object) {
        return Configuration.from(Configuration.toJSONString(object));
    }

    public static Configuration from(List<Object> object) {
        return Configuration.from(Configuration.toJSONString(object));
    }

    private static void checkJSON(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, "The configure file is empty.");
        }
    }

    private static String toJSONString(Object object) {
        return JSON.toJSONString((Object)object);
    }

    public String getNecessaryValue(String key, ErrorCode errorCode) {
        String value = this.getString(key, null);
        if (StringUtils.isBlank((CharSequence)value)) {
            throw AddaxException.asAddaxException(errorCode, String.format("Illegal configuration, the item [%s] is required.", key));
        }
        return value;
    }

    public String getUnnecessaryValue(String key, String defaultValue) {
        String value = this.getString(key, defaultValue);
        if (StringUtils.isBlank((CharSequence)value)) {
            value = defaultValue;
        }
        return value;
    }

    public Object get(String path) {
        this.checkPath(path);
        try {
            return this.findObject(path);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Configuration getConfiguration(String path) {
        Object object = this.get(path);
        if (null == object) {
            return null;
        }
        return Configuration.from(Configuration.toJSONString(object));
    }

    public String getString(String path) {
        Object string = this.get(path);
        if (null == string) {
            return null;
        }
        return String.valueOf(string);
    }

    public String getString(String path, String defaultValue) {
        String result = this.getString(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Character getChar(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Character.valueOf(CharUtils.toChar((String)result));
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("Illegal configuration, cannot be converted to string for [%s], reason: %s.", path, e.getMessage()));
        }
    }

    public Character getChar(String path, char defaultValue) {
        Character result = this.getChar(path);
        if (null == result) {
            return Character.valueOf(defaultValue);
        }
        return result;
    }

    public Boolean getBool(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        if ("true".equalsIgnoreCase(result)) {
            return Boolean.TRUE;
        }
        if ("false".equalsIgnoreCase(result)) {
            return Boolean.FALSE;
        }
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("Illegal configuration, the value [%s] of [%s] cannot be converted to bool type.", path, result));
    }

    public Boolean getBool(String path, boolean defaultValue) {
        Boolean result = this.getBool(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Integer getInt(String path) {
        String result = this.getString(path);
        if (null == result) {
            return null;
        }
        try {
            return Integer.valueOf(result);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("Illegal configuration, the value [%s] of [%s] is expected integer type.", path, e.getMessage()));
        }
    }

    public Integer getInt(String path, int defaultValue) {
        Integer object = this.getInt(path);
        if (null == object) {
            return defaultValue;
        }
        return object;
    }

    public Long getLong(String path) {
        String result = this.getString(path);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        try {
            return Long.valueOf(result);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("Illegal configuration, the value [%s] of [%s] is expected integer/long type.", path, e.getMessage()));
        }
    }

    public Long getLong(String path, long defaultValue) {
        Long result = this.getLong(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public Double getDouble(String path) {
        String result = this.getString(path);
        if (StringUtils.isBlank((CharSequence)result)) {
            return null;
        }
        try {
            return Double.valueOf(result);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("Illegal configuration, the value [%s] of [%s] is expected float type.", path, e.getMessage()));
        }
    }

    public Double getDouble(String path, double defaultValue) {
        Double result = this.getDouble(path);
        if (null == result) {
            return defaultValue;
        }
        return result;
    }

    public List<Object> getList(String path) {
        return this.get(path, List.class);
    }

    public <T> List<T> getList(String path, Class<T> t) {
        ArrayList<String> origin;
        ArrayList<String> object = this.get(path, List.class);
        if (null == object) {
            return new ArrayList();
        }
        ArrayList result = new ArrayList();
        try {
            origin = object;
        }
        catch (ClassCastException e) {
            origin = new ArrayList<String>();
            origin.add(String.valueOf(object));
        }
        for (Object e : origin) {
            result.add(e);
        }
        return result;
    }

    public List<Object> getList(String path, List<Object> defaultList) {
        List<Object> object = this.getList(path);
        if (null == object) {
            return defaultList;
        }
        return object;
    }

    public <T> List<T> getList(String path, List<T> defaultList, Class<T> t) {
        List<T> list = this.getList(path, t);
        if (null == list) {
            return defaultList;
        }
        return list;
    }

    public List<Configuration> getListConfiguration(String path) {
        List<Object> lists = this.getList(path);
        if (lists == null) {
            return new ArrayList<Configuration>();
        }
        ArrayList<Configuration> result = new ArrayList<Configuration>();
        for (Object object : lists) {
            result.add(Configuration.from(Configuration.toJSONString(object)));
        }
        return result;
    }

    public Map<String, Object> getMap(String path) {
        return this.get(path, Map.class);
    }

    public Map<String, Object> getMap(String path, Map<String, Object> defaultMap) {
        Map<String, Object> object = this.getMap(path);
        if (null == object) {
            return defaultMap;
        }
        return object;
    }

    public <T> T get(String path, Class<T> clazz) {
        this.checkPath(path);
        return (T)this.get(path);
    }

    public String beautify() {
        return JSON.toJSONString((Object)this.getInternal(), (JSONWriter.Feature[])new JSONWriter.Feature[]{JSONWriter.Feature.PrettyFormat});
    }

    public Object set(String path, Object object) {
        this.checkPath(path);
        Object result = this.get(path);
        this.setObject(path, this.extractConfiguration(object));
        return result;
    }

    public Set<String> getKeys() {
        HashSet<String> collect = new HashSet<String>();
        this.getKeysRecursive(this.getInternal(), "", collect);
        return collect;
    }

    public Object remove(String path) {
        Object result = this.get(path);
        if (null == result) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, String.format("Illegal configuration, the key [%s] does not exists.", path));
        }
        this.set(path, null);
        return result;
    }

    public Configuration merge(Configuration another, boolean updateWhenConflict) {
        Set<String> keys = another.getKeys();
        keys.forEach(key -> {
            boolean isCurrentExists;
            if (updateWhenConflict) {
                this.set((String)key, another.get((String)key));
                return;
            }
            boolean bl = isCurrentExists = this.get((String)key) != null;
            if (isCurrentExists) {
                return;
            }
            this.set((String)key, another.get((String)key));
        });
        return this;
    }

    public String toString() {
        return this.toJSON();
    }

    public String toJSON() {
        return Configuration.toJSONString(this.getInternal());
    }

    public Configuration clone() {
        Configuration config = Configuration.from(Configuration.toJSONString(this.getInternal()));
        config.addSecretKeyPath(this.secretKeyPathSet);
        return config;
    }

    public void addSecretKeyPath(String path) {
        if (StringUtils.isNotBlank((CharSequence)path)) {
            this.secretKeyPathSet.add(path);
        }
    }

    public void addSecretKeyPath(Set<String> pathSet) {
        if (pathSet != null) {
            this.secretKeyPathSet.addAll(pathSet);
        }
    }

    void getKeysRecursive(Object current, String path, Set<String> collect) {
        boolean isRegularElement;
        boolean bl = isRegularElement = !(current instanceof Map) && !(current instanceof List);
        if (isRegularElement) {
            collect.add(path);
            return;
        }
        boolean isMap = current instanceof Map;
        if (isMap) {
            Map mapping = (Map)current;
            mapping.keySet().forEach(key -> {
                if (StringUtils.isBlank((CharSequence)path)) {
                    this.getKeysRecursive(mapping.get(key), key.trim(), collect);
                } else {
                    this.getKeysRecursive(mapping.get(key), path + "." + key.trim(), collect);
                }
            });
            return;
        }
        List lists = (List)current;
        for (int i = 0; i < lists.size(); ++i) {
            this.getKeysRecursive(lists.get(i), path + String.format("[%d]", i), collect);
        }
    }

    public Object getInternal() {
        return this.root;
    }

    private void setObject(String path, Object object) {
        Object newRoot = this.setObjectRecursive(this.root, this.split2List(path), 0, object);
        if (this.isSuitForRoot(newRoot)) {
            this.root = newRoot;
            return;
        }
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, String.format("Illegal value, cannot set value [%s] for key [%s]", ToStringBuilder.reflectionToString((Object)object), path));
    }

    private Object extractConfiguration(Object object) {
        if (object instanceof Configuration) {
            return this.extractFromConfiguration(object);
        }
        if (object instanceof List) {
            ArrayList<Object> result = new ArrayList<Object>();
            for (Object each : (List)object) {
                result.add(this.extractFromConfiguration(each));
            }
            return result;
        }
        if (object instanceof Map) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (String key : ((Map)object).keySet()) {
                result.put(key, this.extractFromConfiguration(((Map)object).get(key)));
            }
            return result;
        }
        return object;
    }

    private Object extractFromConfiguration(Object object) {
        if (object instanceof Configuration) {
            return ((Configuration)object).getInternal();
        }
        return object;
    }

    Object buildObject(List<String> paths, Object object) {
        if (null == paths) {
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, "The Path cannot be null");
        }
        if (1 == paths.size() && StringUtils.isBlank((CharSequence)paths.get(0))) {
            return object;
        }
        Cloneable child = object;
        for (int i = paths.size() - 1; i >= 0; --i) {
            String path = paths.get(i);
            if (this.isPathMap(path)) {
                HashMap mapping = new HashMap();
                mapping.put(path, child);
                child = mapping;
                continue;
            }
            if (this.isPathList(path)) {
                ArrayList<Object> lists = new ArrayList<Object>(this.getIndex(path) + 1);
                this.expand(lists, this.getIndex(path) + 1);
                lists.set(this.getIndex(path), child);
                child = lists;
                continue;
            }
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, String.format("the value [%s] of [%s] is illegal.", StringUtils.join(paths, (String)"."), path));
        }
        return child;
    }

    Object setObjectRecursive(Object current, List<String> paths, int index, Object value) {
        boolean isLastIndex;
        boolean bl = isLastIndex = index == paths.size();
        if (isLastIndex) {
            return value;
        }
        String path = paths.get(index).trim();
        boolean isNeedMap = this.isPathMap(path);
        if (isNeedMap) {
            boolean isCurrentMap = current instanceof Map;
            if (!isCurrentMap) {
                HashMap<String, Object> mapping = new HashMap<String, Object>();
                mapping.put(path, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return mapping;
            }
            Map mapping = (Map)current;
            boolean hasSameKey = mapping.containsKey(path);
            if (!hasSameKey) {
                mapping.put(path, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return mapping;
            }
            current = mapping.get(path);
            mapping.put(path, this.setObjectRecursive(current, paths, index + 1, value));
            return mapping;
        }
        boolean isNeedList = this.isPathList(path);
        if (isNeedList) {
            boolean hasSameIndex;
            int listIndexer = this.getIndex(path);
            boolean isCurrentList = current instanceof List;
            if (!isCurrentList) {
                List<Object> lists = this.expand(new ArrayList<Object>(), listIndexer + 1);
                lists.set(listIndexer, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return lists;
            }
            List<Object> lists = this.expand((List)current, listIndexer + 1);
            boolean bl2 = hasSameIndex = lists.get(listIndexer) != null;
            if (!hasSameIndex) {
                lists.set(listIndexer, this.buildObject(paths.subList(index + 1, paths.size()), value));
                return lists;
            }
            current = lists.get(listIndexer);
            lists.set(listIndexer, this.setObjectRecursive(current, paths, index + 1, value));
            return lists;
        }
        throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.RUNTIME_ERROR, "System internal error.");
    }

    private Object findObject(String path) {
        boolean isRootQuery = StringUtils.isBlank((CharSequence)path);
        if (isRootQuery) {
            return this.root;
        }
        Object target = this.root;
        for (String each : this.split2List(path)) {
            if (this.isPathMap(each)) {
                target = this.findObjectInMap(target, each);
                continue;
            }
            target = this.findObjectInList(target, each);
        }
        return target;
    }

    private Object findObjectInMap(Object target, String index) {
        boolean isMap = target instanceof Map;
        if (!isMap) {
            throw new IllegalArgumentException(String.format("The item [%s] requires a Map object in json format, but the actual type is [%s].", index, target.getClass().toString()));
        }
        Object result = ((Map)target).get(index);
        if (null == result) {
            throw new IllegalArgumentException(String.format("The value of item [%s] is null.", index));
        }
        return result;
    }

    private Object findObjectInList(Object target, String each) {
        boolean isList = target instanceof List;
        if (!isList) {
            throw new IllegalArgumentException(String.format("The item [%s] requires a Map object in json format, but the actual type is [%s].", each, target.getClass().toString()));
        }
        String index = each.replace("[", "").replace("]", "");
        if (!StringUtils.isNumeric((CharSequence)index)) {
            throw new IllegalArgumentException(String.format("The list subscript must be a numeric type, but the actual type is [%s].", index));
        }
        return ((List)target).get(Integer.parseInt(index));
    }

    private List<Object> expand(List<Object> list, int size) {
        int expand = size - list.size();
        while (expand-- > 0) {
            list.add(null);
        }
        return list;
    }

    private boolean isPathList(String path) {
        return path.contains("[") && path.contains("]");
    }

    private boolean isPathMap(String path) {
        return StringUtils.isNotBlank((CharSequence)path) && !this.isPathList(path);
    }

    private int getIndex(String index) {
        return Integer.parseInt(index.replace("[", "").replace("]", ""));
    }

    private boolean isSuitForRoot(Object object) {
        return object instanceof List || object instanceof Map;
    }

    private String split(String path) {
        return StringUtils.replace((String)path, (String)"[", (String)".[");
    }

    private List<String> split2List(String path) {
        return Arrays.asList(StringUtils.split((String)this.split(path), (String)"."));
    }

    private void checkPath(String path) {
        if (null == path) {
            throw new IllegalArgumentException("System internal error.");
        }
        for (String each : StringUtils.split((String)".")) {
            if (!StringUtils.isBlank((CharSequence)each)) continue;
            throw new IllegalArgumentException(String.format("The item [%s] is invalid, Blank characters should not  appear here.", path));
        }
    }

    public Set<String> getSecretKeyPathSet() {
        return this.secretKeyPathSet;
    }

    public void setSecretKeyPathSet(Set<String> keyPathSet) {
        if (keyPathSet != null) {
            this.secretKeyPathSet = keyPathSet;
        }
    }
}

