/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.util;

import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.exception.CommonErrorCode;
import com.wgzhao.addax.common.spi.ErrorCode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public final class ListUtil {
    private static final String ERROR_MESSAGE = "Invalid configuration, the List cannot be empty.";

    private ListUtil() {
    }

    public static void makeSureNoValueDuplicate(List<String> aList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty()) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        if (1 != aList.size()) {
            List<String> list = !caseSensitive ? ListUtil.valueToLowerCase(aList) : new ArrayList<String>(aList);
            Collections.sort(list);
            int len = list.size() - 1;
            for (int i = 0; i < len; ++i) {
                if (!list.get(i).equals(list.get(i + 1))) continue;
                throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u60a8\u63d0\u4f9b\u7684\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u6709\u8bef, String:[%s] \u4e0d\u5141\u8bb8\u91cd\u590d\u51fa\u73b0\u5728\u5217\u8868\u4e2d: [%s].", list.get(i), StringUtils.join(aList, (String)",")));
            }
        }
    }

    public static boolean checkIfBInA(List<String> aList, List<String> bList, boolean caseSensitive) {
        if (null == aList || aList.isEmpty() || null == bList || bList.isEmpty()) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        try {
            ListUtil.makeSureBInA(aList, bList, caseSensitive);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static void makeSureBInA(List<String> aList, List<String> bList, boolean caseSensitive) {
        List<String> part;
        List<String> all;
        if (null == aList || aList.isEmpty() || null == bList || bList.isEmpty()) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        if (!caseSensitive) {
            all = ListUtil.valueToLowerCase(aList);
            part = ListUtil.valueToLowerCase(bList);
        } else {
            all = new ArrayList<String>(aList);
            part = new ArrayList<String>(bList);
        }
        for (String oneValue : part) {
            if (all.contains(oneValue)) continue;
            throw AddaxException.asAddaxException((ErrorCode)CommonErrorCode.CONFIG_ERROR, String.format("\u60a8\u63d0\u4f9b\u7684\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u6709\u8bef, String:[%s] \u4e0d\u5b58\u5728\u4e8e\u5217\u8868\u4e2d:[%s].", oneValue, StringUtils.join(aList, (String)",")));
        }
    }

    public static boolean checkIfValueSame(List<Boolean> aList) {
        if (null == aList || aList.isEmpty()) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        if (1 != aList.size()) {
            Boolean firstValue = aList.get(0);
            int len = aList.size();
            for (int i = 1; i < len; ++i) {
                if (firstValue.booleanValue() == aList.get(i).booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    public static List<String> valueToLowerCase(List<String> aList) {
        if (null == aList || aList.isEmpty()) {
            throw new IllegalArgumentException(ERROR_MESSAGE);
        }
        ArrayList<String> result = new ArrayList<String>(aList.size());
        for (String oneValue : aList) {
            result.add(null != oneValue ? oneValue.toLowerCase() : null);
        }
        return result;
    }
}

