/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class MathUtil {
    private static final int DEF_DIV_SCALE = 2;

    private MathUtil() {
    }

    public static BigDecimal add(BigDecimal v1, BigDecimal v2) {
        if (null == v1) {
            v1 = BigDecimal.ZERO;
        }
        if (null == v2) {
            v2 = BigDecimal.ZERO;
        }
        return v1.add(v2);
    }

    public static BigDecimal subtract(BigDecimal v1, BigDecimal v2) {
        if (null == v1) {
            v1 = BigDecimal.ZERO;
        }
        if (null == v2) {
            v2 = BigDecimal.ZERO;
        }
        return v1.subtract(v2);
    }

    public static BigDecimal multiply(BigDecimal v1, BigDecimal v2) {
        if (null == v1) {
            v1 = BigDecimal.ONE;
        }
        if (null == v2) {
            v2 = BigDecimal.ONE;
        }
        return v1.multiply(v2);
    }

    public static BigDecimal pow(BigDecimal v1, int v2) {
        if (null == v1) {
            v1 = BigDecimal.ONE;
        }
        return v1.pow(v2);
    }

    public static BigDecimal divide(BigDecimal v1, BigDecimal v2) {
        return v1.divide(v2, 2, RoundingMode.HALF_UP);
    }

    public static BigDecimal divide(BigDecimal v1, BigDecimal v2, Integer scale) {
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (null == v2) {
            v2 = BigDecimal.ONE;
        }
        if (v2.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException("The divisor cannot be zero.");
        }
        if (scale < 0) {
            throw new IllegalArgumentException("The scale cannot be less than zero.");
        }
        return v1.divide(v2, (int)scale, RoundingMode.HALF_UP);
    }

    public static BigDecimal mod(BigDecimal v1, BigDecimal v2) {
        if (null == v1) {
            return BigDecimal.ZERO;
        }
        if (null == v2) {
            v2 = BigDecimal.ONE;
        }
        if (v2.compareTo(BigDecimal.ZERO) == 0) {
            throw new IllegalArgumentException("The divisor cannot be zero.");
        }
        BigDecimal[] c = v1.divideAndRemainder(v2);
        return c[1];
    }

    public static String add(String v1, String v2) {
        if (MathUtil.isBlank(v1)) {
            v1 = "0";
        }
        if (MathUtil.isBlank(v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1.trim());
        BigDecimal b2 = new BigDecimal(v2.trim());
        return String.valueOf(MathUtil.add(b1, b2));
    }

    public static String subtract(String v1, String v2) {
        if (MathUtil.isBlank(v1)) {
            v1 = "0";
        }
        if (MathUtil.isBlank(v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1.trim());
        BigDecimal b2 = new BigDecimal(v2.trim());
        return String.valueOf(MathUtil.subtract(b1, b2));
    }

    public static String multiply(String v1, String v2) {
        if (MathUtil.isBlank(v1)) {
            v1 = "1";
        }
        if (MathUtil.isBlank(v2)) {
            v2 = "1";
        }
        BigDecimal b1 = new BigDecimal(v1.trim());
        BigDecimal b2 = new BigDecimal(v2.trim());
        return String.valueOf(MathUtil.multiply(b1, b2));
    }

    public static String pow(String v1, String v2) {
        if (MathUtil.isBlank(v1)) {
            v1 = "1";
        }
        if (MathUtil.isBlank(v2)) {
            v2 = "0";
        }
        BigDecimal b1 = new BigDecimal(v1.trim());
        int b2 = Integer.parseInt(v2.trim());
        return String.valueOf(MathUtil.pow(b1, b2));
    }

    public static String divide(String v1, String v2) {
        return MathUtil.divide(v1, v2, (Integer)2);
    }

    public static String divide(String v1, String v2, Integer scale) {
        if (null == v1) {
            return "0";
        }
        if (null == v2) {
            v2 = "1";
        }
        BigDecimal b1 = new BigDecimal(v1.trim());
        BigDecimal b2 = new BigDecimal(v2.trim());
        return String.valueOf(MathUtil.divide(b1, b2, scale));
    }

    public static String mod(String v1, String v2) {
        if (null == v1) {
            return "0";
        }
        if (null == v2) {
            v2 = "1";
        }
        BigDecimal b1 = new BigDecimal(v1.trim());
        BigDecimal b2 = new BigDecimal(v2.trim());
        BigDecimal[] c = b1.divideAndRemainder(b2);
        return String.valueOf(c[1]);
    }

    public static BigDecimal sum(BigDecimal v1, BigDecimal ... valList) {
        if (null == v1) {
            v1 = BigDecimal.ZERO;
        }
        if (null == valList || valList.length == 0) {
            return v1;
        }
        for (BigDecimal val : valList) {
            if (null == val) continue;
            v1 = v1.add(val);
        }
        return v1;
    }

    public static String sum(String v1, String ... valList) {
        if (MathUtil.isBlank(v1)) {
            v1 = "0";
        }
        if (null == valList || valList.length == 0) {
            return v1;
        }
        BigDecimal b1 = new BigDecimal(v1.trim());
        for (String val : valList) {
            if (MathUtil.isBlank(val)) continue;
            b1 = MathUtil.add(b1, new BigDecimal(val.trim()));
        }
        return String.valueOf(b1);
    }

    public static BigDecimal avg(BigDecimal ... valList) {
        if (null != valList && valList.length != 0) {
            return MathUtil.divide(MathUtil.sum(BigDecimal.ZERO, valList), new BigDecimal(valList.length));
        }
        return BigDecimal.ZERO;
    }

    public static String avg(String ... valList) {
        if (null != valList && valList.length != 0) {
            return MathUtil.divide(MathUtil.sum("0", valList), String.valueOf(valList.length));
        }
        return "0";
    }

    public static BigDecimal max(BigDecimal v1, BigDecimal ... valList) {
        BigDecimal max = v1;
        if (null == valList || valList.length == 0) {
            return max;
        }
        for (BigDecimal val : valList) {
            if (null == val || val.compareTo(max) <= 0) continue;
            max = val;
        }
        return max;
    }

    public static BigDecimal maxArr(BigDecimal ... valList) {
        if (null == valList || valList.length == 0) {
            return null;
        }
        return MathUtil.max(valList[0], valList);
    }

    public static BigDecimal min(BigDecimal v1, BigDecimal ... valList) {
        BigDecimal min = v1;
        if (null == valList || valList.length == 0) {
            return min;
        }
        for (BigDecimal val : valList) {
            if (null == val || val.compareTo(min) >= 0) continue;
            min = val;
        }
        return min;
    }

    public static BigDecimal minArr(BigDecimal ... valList) {
        if (null == valList || valList.length == 0) {
            return null;
        }
        return MathUtil.min(valList[0], valList);
    }

    public static String max(String v1, String ... valList) {
        if (MathUtil.isBlank(v1)) {
            return null;
        }
        if (null == valList || valList.length == 0) {
            return v1;
        }
        BigDecimal maxBd = new BigDecimal(v1.trim());
        for (String val : valList) {
            if (MathUtil.isBlank(val) || new BigDecimal(val).compareTo(maxBd) <= 0) continue;
            maxBd = new BigDecimal(val);
        }
        return String.valueOf(maxBd);
    }

    public static String maxArr(String ... valList) {
        if (null == valList || valList.length == 0) {
            return null;
        }
        return MathUtil.max(valList[0], valList);
    }

    public static String min(String v1, String ... valList) {
        if (MathUtil.isBlank(v1)) {
            return null;
        }
        if (null == valList || valList.length == 0) {
            return v1;
        }
        BigDecimal minBd = new BigDecimal(v1.trim());
        for (String val : valList) {
            if (MathUtil.isBlank(val) || new BigDecimal(val).compareTo(minBd) >= 0) continue;
            minBd = new BigDecimal(val);
        }
        return String.valueOf(minBd);
    }

    public static String minArr(String ... valList) {
        if (null == valList || valList.length == 0) {
            return null;
        }
        return MathUtil.min(valList[0], valList);
    }

    private static boolean isBlank(String str) {
        return null == str || str.trim().length() == 0;
    }
}

