/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.storage.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.wgzhao.addax.common.compress.ExpandLzopInputStream;
import com.wgzhao.addax.common.compress.ZipCycleInputStream;
import com.wgzhao.addax.common.constant.Type;
import com.wgzhao.addax.common.element.BoolColumn;
import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.ColumnEntry;
import com.wgzhao.addax.common.element.DateColumn;
import com.wgzhao.addax.common.element.DoubleColumn;
import com.wgzhao.addax.common.element.LongColumn;
import com.wgzhao.addax.common.element.Record;
import com.wgzhao.addax.common.element.StringColumn;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.plugin.RecordSender;
import com.wgzhao.addax.common.plugin.TaskPluginCollector;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.util.Configuration;
import com.wgzhao.addax.storage.reader.StorageReaderErrorCode;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.UnsupportedCharsetException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageReaderUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StorageReaderUtil.class);

    private StorageReaderUtil() {
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void readFromStream(InputStream inputStream, String fileName, Configuration readerSliceConfig, RecordSender recordSender, TaskPluginCollector taskPluginCollector) {
        List column;
        String compress = readerSliceConfig.getString("compress", "");
        String encoding = readerSliceConfig.getString("encoding", "UTF-8");
        if (StringUtils.isBlank((CharSequence)encoding)) {
            encoding = "UTF-8";
            LOG.warn("The encoding: [{}] is illegal, uses [{}] by default", (Object)encoding, (Object)"UTF-8");
        }
        if (null != (column = readerSliceConfig.getListConfiguration("column")) && 1 == column.size() && "\"*\"".equals(((Configuration)column.get(0)).toString())) {
            readerSliceConfig.set("column", null);
        }
        BufferedReader reader = null;
        int bufferSize = readerSliceConfig.getInt("bufferSize", 8192);
        try {
            if (compress == null || "".equals(compress) || "none".equalsIgnoreCase(compress)) {
                reader = new BufferedReader(new InputStreamReader(inputStream, encoding), bufferSize);
            } else if ("zip".equalsIgnoreCase(compress)) {
                ZipCycleInputStream zipCycleInputStream = new ZipCycleInputStream(inputStream);
                reader = new BufferedReader(new InputStreamReader((InputStream)zipCycleInputStream, encoding), bufferSize);
            } else if ("lzo".equalsIgnoreCase(compress)) {
                ExpandLzopInputStream expandLzopInputStream = new ExpandLzopInputStream(inputStream);
                reader = new BufferedReader(new InputStreamReader((InputStream)expandLzopInputStream, encoding), bufferSize);
            } else {
                CompressorInputStream input = new CompressorStreamFactory().createCompressorInputStream(compress.toUpperCase(), inputStream, true);
                reader = new BufferedReader(new InputStreamReader((InputStream)input, encoding), bufferSize);
            }
            StorageReaderUtil.doReadFromStream(reader, fileName, readerSliceConfig, recordSender, taskPluginCollector);
        }
        catch (UnsupportedEncodingException uee) {
            try {
                throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.OPEN_FILE_WITH_CHARSET_ERROR, (String)String.format("%s is unsupported", encoding), (Throwable)uee);
                catch (NullPointerException e) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.RUNTIME_EXCEPTION, (Throwable)e);
                }
                catch (IOException e) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.READ_FILE_IO_ERROR, (String)String.format("Failed to read stream [%s].", fileName), (Throwable)e);
                }
                catch (CompressorException e) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.ILLEGAL_VALUE, (String)("The compress algorithm [" + compress + "] is unsupported yet"));
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)reader, null);
    }

    public static void doReadFromStream(BufferedReader reader, String fileName, Configuration readerSliceConfig, RecordSender recordSender, TaskPluginCollector taskPluginCollector) {
        CSVFormat.Builder csvFormatBuilder = CSVFormat.DEFAULT.builder();
        String encoding = readerSliceConfig.getString("encoding", "UTF-8");
        String delimiterInStr = readerSliceConfig.getString("fieldDelimiter");
        if (null != delimiterInStr && 1 != delimiterInStr.length()) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.ILLEGAL_VALUE, (String)String.format("The delimiter ONLY has one char, [%s] is illegal", delimiterInStr));
        }
        if (null == delimiterInStr) {
            LOG.warn("Uses [{}] as delimiter by default", (Object)Character.valueOf(','));
        }
        Character fieldDelimiter = readerSliceConfig.getChar("fieldDelimiter", ',');
        csvFormatBuilder.setDelimiter(fieldDelimiter.charValue());
        String nullFormat = readerSliceConfig.getString("nullFormat");
        csvFormatBuilder.setNullString(nullFormat);
        Boolean skipHeader = readerSliceConfig.getBool("skipHeader", false);
        csvFormatBuilder.setSkipHeaderRecord(skipHeader.booleanValue());
        List<ColumnEntry> column = StorageReaderUtil.getListColumnEntry(readerSliceConfig, "column");
        try {
            CSVParser csvParser = new CSVParser((Reader)reader, csvFormatBuilder.build());
            csvParser.stream().filter(Objects::nonNull).forEach(csvRecord -> StorageReaderUtil.transportOneRecord(recordSender, column, csvRecord.toList().toArray(new String[0]), nullFormat, taskPluginCollector));
        }
        catch (UnsupportedEncodingException uee) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.OPEN_FILE_WITH_CHARSET_ERROR, (String)String.format("The encoding: [%s] is unsupported", encoding), (Throwable)uee);
        }
        catch (FileNotFoundException fnfe) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.FILE_NOT_EXISTS, (String)String.format("The file [%s] does not exists ", fileName), (Throwable)fnfe);
        }
        catch (IOException ioe) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.READ_FILE_IO_ERROR, (String)String.format("Failed to ead file [%s]", fileName), (Throwable)ioe);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.RUNTIME_EXCEPTION, (Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)reader, null);
        }
    }

    public static void transportOneRecord(RecordSender recordSender, Configuration configuration, TaskPluginCollector taskPluginCollector, String line) {
        List<ColumnEntry> column = StorageReaderUtil.getListColumnEntry(configuration, "column");
        String nullFormat = configuration.getString("nullFormat");
        Character fieldDelimiter = configuration.getChar("fieldDelimiter", ',');
        String[] sourceLine = StringUtils.split((String)line, (char)fieldDelimiter.charValue());
        StorageReaderUtil.transportOneRecord(recordSender, column, sourceLine, nullFormat, taskPluginCollector);
    }

    public static void transportOneRecord(RecordSender recordSender, List<ColumnEntry> columnConfigs, String[] sourceLine, String nullFormat, TaskPluginCollector taskPluginCollector) {
        Record record = recordSender.createRecord();
        if (null == columnConfigs || columnConfigs.isEmpty()) {
            for (String columnValue : sourceLine) {
                StringColumn columnGenerated = columnValue.equals(nullFormat) ? new StringColumn(null) : new StringColumn(columnValue);
                record.addColumn((Column)columnGenerated);
            }
            recordSender.sendToWriter(record);
        } else {
            try {
                for (ColumnEntry columnConfig : columnConfigs) {
                    StringColumn columnGenerated;
                    String columnValue;
                    String columnType = columnConfig.getType();
                    Integer columnIndex = columnConfig.getIndex();
                    String columnConst = columnConfig.getValue();
                    if (null == columnIndex && null == columnConst) {
                        throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.NO_INDEX_VALUE, (String)"The index or constant is required when type is present.");
                    }
                    if (null != columnIndex && null != columnConst) {
                        throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.MIXED_INDEX_VALUE, (String)"The index and value are both present, choose one of them");
                    }
                    if (null != columnIndex) {
                        if (columnIndex >= sourceLine.length) {
                            throw new IndexOutOfBoundsException(String.format("The column index [%s] you try to read is out of range[%s]: [%s]", columnIndex + 1, sourceLine.length, StringUtils.join((Object[])sourceLine, (String)",")));
                        }
                        columnValue = sourceLine[columnIndex];
                    } else {
                        columnValue = columnConst;
                    }
                    Type type = Type.valueOf((String)columnType.toUpperCase());
                    if (columnValue == null || columnValue.equals(nullFormat)) {
                        record.addColumn((Column)new StringColumn());
                        continue;
                    }
                    try {
                        switch (type) {
                            case STRING: {
                                columnGenerated = new StringColumn(columnValue);
                                break;
                            }
                            case LONG: {
                                columnGenerated = new LongColumn(columnValue);
                                break;
                            }
                            case DOUBLE: {
                                columnGenerated = new DoubleColumn(columnValue);
                                break;
                            }
                            case BOOLEAN: {
                                columnGenerated = new BoolColumn(columnValue);
                                break;
                            }
                            case DATE: {
                                String formatString = columnConfig.getFormat();
                                if (StringUtils.isNotBlank((CharSequence)formatString)) {
                                    DateFormat format = columnConfig.getDateFormat();
                                    columnGenerated = new DateColumn(format.parse(columnValue));
                                    break;
                                }
                                columnGenerated = new DateColumn(new StringColumn(columnValue).asDate());
                                break;
                            }
                            default: {
                                String errorMessage = String.format("The column type [%s] is unsupported", columnType);
                                LOG.error(errorMessage);
                                throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.NOT_SUPPORT_TYPE, (String)errorMessage);
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(String.format("Cast value [%s] to type [%s] failure", columnValue, type.name()));
                    }
                    record.addColumn((Column)columnGenerated);
                }
                recordSender.sendToWriter(record);
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException iae) {
                LOG.error(iae.getMessage());
                taskPluginCollector.collectDirtyRecord(record, iae.getMessage());
            }
            catch (Exception e) {
                if (e instanceof AddaxException) {
                    throw (AddaxException)e;
                }
                taskPluginCollector.collectDirtyRecord(record, e.getMessage());
            }
        }
    }

    public static List<ColumnEntry> getListColumnEntry(Configuration configuration, String path) {
        List lists = configuration.getList(path, JSONObject.class);
        if (lists == null) {
            return null;
        }
        ArrayList<ColumnEntry> result = new ArrayList<ColumnEntry>();
        for (JSONObject object : lists) {
            result.add((ColumnEntry)JSON.parseObject((String)object.toJSONString(new JSONWriter.Feature[0]), ColumnEntry.class));
        }
        return result;
    }

    public static void validateParameter(Configuration readerConfiguration) {
        StorageReaderUtil.validateEncoding(readerConfiguration);
        StorageReaderUtil.validateFieldDelimiter(readerConfiguration);
        StorageReaderUtil.validateColumn(readerConfiguration);
    }

    public static void validateEncoding(Configuration readerConfiguration) {
        String encoding = readerConfiguration.getString("encoding", "UTF-8");
        try {
            encoding = encoding.trim();
            readerConfiguration.set("encoding", (Object)encoding);
            Charsets.toCharset((String)encoding);
        }
        catch (UnsupportedCharsetException uce) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.ILLEGAL_VALUE, (String)String.format("The encoding [%s] is unsupported yet.", encoding), (Throwable)uce);
        }
        catch (Exception e) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.CONFIG_INVALID_EXCEPTION, (String)String.format("Exception occurred while applying encoding [%s].", e.getMessage()), (Throwable)e);
        }
    }

    public static void validateCompress(Configuration readerConfiguration) {
        String compress = readerConfiguration.getUnnecessaryValue("compress", "").toLowerCase();
        if ("gzip".equals(compress)) {
            compress = "gz";
        }
        readerConfiguration.set("compress", (Object)compress);
    }

    public static void validateFieldDelimiter(Configuration readerConfiguration) {
        String delimiterInStr = readerConfiguration.getString("fieldDelimiter", ",");
        if (null == delimiterInStr) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.REQUIRED_VALUE, (String)String.format("The item [%s] is required.", "fieldDelimiter"));
        }
        if (1 != delimiterInStr.length()) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.ILLEGAL_VALUE, (String)String.format("The delimiter only support single character, [%s] is invalid.", delimiterInStr));
        }
    }

    public static void validateColumn(Configuration readerConfiguration) {
        String columnsInStr;
        List columns = readerConfiguration.getListConfiguration("column");
        if (null == columns || columns.isEmpty()) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.REQUIRED_VALUE, (String)"The item columns is required.");
        }
        if (1 == columns.size() && ("\"*\"".equals(columnsInStr = ((Configuration)columns.get(0)).toString()) || "'*'".equals(columnsInStr))) {
            readerConfiguration.set("column", null);
            columns = null;
        }
        if (null != columns && !columns.isEmpty()) {
            for (Configuration eachColumnConf : columns) {
                eachColumnConf.getNecessaryValue("type", (ErrorCode)StorageReaderErrorCode.REQUIRED_VALUE);
                Integer columnIndex = eachColumnConf.getInt("index");
                String columnValue = eachColumnConf.getString("value");
                if (null == columnIndex && null == columnValue) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.NO_INDEX_VALUE, (String)"You must configure one of index or name or value");
                }
                if (null != columnIndex && null != columnValue) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.MIXED_INDEX_VALUE, (String)"You both configure index, value, or name, you can ONLY specify the one each column");
                }
                if (null == columnIndex || columnIndex >= 0) continue;
                throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.ILLEGAL_VALUE, (String)String.format("The value of index must be greater than 0, %s is illegal", columnIndex));
            }
        }
    }

    public static String getRegexPathParentPath(String regexPath) {
        int lastDirSeparator = regexPath.lastIndexOf(IOUtils.DIR_SEPARATOR);
        String parentPath = regexPath.substring(0, lastDirSeparator + 1);
        if (parentPath.contains("*") || parentPath.contains("?")) {
            throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.ILLEGAL_VALUE, (String)String.format("The path '%s' is illegal, ONLY the trail folder can container wildcard * or ? ", regexPath));
        }
        return parentPath;
    }
}

