/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.storage.util;

import com.google.common.collect.ImmutableMap;
import com.wgzhao.addax.common.compress.ZipCycleInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorInputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.RandomStringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    public static final Logger LOG = LoggerFactory.getLogger(FileHelper.class);
    private static final ImmutableMap<String, String> COMPRESS_TYPE_SUFFIX_MAP = new ImmutableMap.Builder().put((Object)"BZIP", (Object)".bz2").put((Object)"BZIP2", (Object)".bz2").put((Object)"DEFLATE", (Object)".deflate").put((Object)"DEFLATE64", (Object)".deflate").put((Object)"GZIP", (Object)".gz").put((Object)"GZ", (Object)".gz").put((Object)"LZ4", (Object)".lz4").put((Object)"LZ4-BLOCK", (Object)".lz4").put((Object)"LZ4-FRAMED", (Object)".lz4").put((Object)"LZO", (Object)".lzo").put((Object)"LZOP", (Object)".lzo").put((Object)"SNAPPY", (Object)".snappy").put((Object)"XZ", (Object)".xz").put((Object)"Z", (Object)".z").put((Object)"ZIP", (Object)".zip").put((Object)"ZLIB", (Object)".zlib").put((Object)"ZSTANDARD", (Object)".zstd").put((Object)"ZSTD", (Object)".zstd").build();
    public static final HashMap<String, String> mFileTypes = new HashMap();

    public static String getFileCompressType(String fileName) {
        try {
            FileInputStream inputStream = new FileInputStream(FilenameUtils.getFullPath((String)fileName));
            String fileType = FileHelper.getFileCompressType(inputStream);
            ((InputStream)inputStream).close();
            return fileType;
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + fileName, e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close file: ", e);
        }
    }

    public static String getFileCompressType(InputStream inputStream) {
        try {
            return CompressorStreamFactory.detect((InputStream)inputStream);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("does not support mark", e);
        }
        catch (CompressorException e) {
            return "none";
        }
    }

    public static String getCompressFileSuffix(String compress) {
        if (compress == null || compress.isEmpty() || "none".equalsIgnoreCase(compress)) {
            return "";
        }
        return (String)COMPRESS_TYPE_SUFFIX_MAP.getOrDefault((Object)compress.toUpperCase(), (Object)("." + compress.toLowerCase()));
    }

    public static BufferedReader readCompressFile(String fileName, String encoding, int bufferSize) {
        FileInputStream inputStream;
        try {
            inputStream = new FileInputStream(FilenameUtils.getFullPath((String)fileName));
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("File not found: " + fileName, e);
        }
        try {
            String compressType = FileHelper.getFileCompressType(fileName);
            if ("none".equals(compressType)) {
                return new BufferedReader(new InputStreamReader((InputStream)inputStream, encoding), bufferSize);
            }
            if ("zip".equals(compressType)) {
                ZipCycleInputStream zis = new ZipCycleInputStream((InputStream)inputStream);
                return new BufferedReader(new InputStreamReader((InputStream)zis, encoding), bufferSize);
            }
            BufferedInputStream bis = new BufferedInputStream(inputStream);
            CompressorInputStream input = new CompressorStreamFactory().createCompressorInputStream(compressType, (InputStream)bis, true);
            return new BufferedReader(new InputStreamReader((InputStream)input, encoding), bufferSize);
        }
        catch (IOException | CompressorException e) {
            throw new RuntimeException("Failed to read compress file", e);
        }
    }

    public static boolean checkDirectoryReadable(String directory) {
        return FileHelper.checkDirPermission(directory, "r");
    }

    public static boolean checkDirectoryWritable(String directory) {
        return FileHelper.checkDirPermission(directory, "w");
    }

    private static boolean checkDirPermission(String directory, String permission) {
        File file = new File(FilenameUtils.getFullPath((String)directory));
        if (!file.exists()) {
            throw new RuntimeException("The directory [" + directory + "] does not exists.");
        }
        if (!file.isDirectory()) {
            throw new RuntimeException("The [" + directory + "] is not a directory.");
        }
        if ("r".equalsIgnoreCase(permission)) {
            return file.canRead();
        }
        return file.canWrite();
    }

    public static Pattern generatePattern(String dir) {
        String regexString = dir.replace("*", ".*").replace("?", ".?");
        return Pattern.compile(regexString);
    }

    public static boolean isTargetFile(Map<String, Pattern> patterns, Map<String, Boolean> isRegexPath, String regexPath, String absoluteFilePath) {
        if (isRegexPath.get(regexPath).booleanValue()) {
            return patterns.get(regexPath).matcher(absoluteFilePath).matches();
        }
        return true;
    }

    public static List<String> buildSourceTargets(List<String> directories) {
        HashMap<String, Boolean> isRegexPath = new HashMap<String, Boolean>();
        HashMap<String, Pattern> patterns = new HashMap<String, Pattern>();
        HashSet<String> toBeReadFiles = new HashSet<String>();
        for (String eachPath : directories) {
            String parentDirectory;
            int endMark;
            for (endMark = 0; endMark < eachPath.length(); ++endMark) {
                if ('*' != eachPath.charAt(endMark) && '?' != eachPath.charAt(endMark)) continue;
                isRegexPath.put(eachPath, true);
                patterns.put(eachPath, FileHelper.generatePattern(eachPath));
                break;
            }
            if (!isRegexPath.isEmpty() && ((Boolean)isRegexPath.get(eachPath)).booleanValue()) {
                int lastDirSeparator = eachPath.substring(0, endMark).lastIndexOf(IOUtils.DIR_SEPARATOR);
                parentDirectory = eachPath.substring(0, lastDirSeparator + 1);
            } else {
                isRegexPath.put(eachPath, false);
                parentDirectory = eachPath;
            }
            FileHelper.buildSourceTargetsEachPath(eachPath, parentDirectory, toBeReadFiles, patterns, isRegexPath);
        }
        return Arrays.asList(toBeReadFiles.toArray(new String[0]));
    }

    private static void buildSourceTargetsEachPath(String regexPath, String parentDirectory, Set<String> toBeReadFiles, Map<String, Pattern> patterns, Map<String, Boolean> isRegexPath) {
        assert (FileHelper.checkDirectoryReadable(parentDirectory));
        FileHelper.directoryRover(regexPath, parentDirectory, toBeReadFiles, patterns, isRegexPath);
    }

    private static void directoryRover(String regexPath, String parentDirectory, Set<String> toBeReadFiles, Map<String, Pattern> patterns, Map<String, Boolean> isRegexPath) {
        block7: {
            File directory = new File(parentDirectory);
            if (!directory.isDirectory()) {
                if (FileHelper.isTargetFile(patterns, isRegexPath, regexPath, directory.getAbsolutePath())) {
                    toBeReadFiles.add(parentDirectory);
                    LOG.info("Adding the file [{}] as a candidate to be read.", (Object)parentDirectory);
                }
            } else {
                try {
                    File[] files = directory.listFiles();
                    if (null != files) {
                        for (File subFileNames : files) {
                            FileHelper.directoryRover(regexPath, subFileNames.getAbsolutePath(), toBeReadFiles, patterns, isRegexPath);
                        }
                        break block7;
                    }
                    String message = String.format("Permission denied for reading directory [%s].", directory);
                    LOG.error(message);
                    throw new RuntimeException(message);
                }
                catch (SecurityException e) {
                    String message = String.format("Permission denied for reading directory [%s].", directory);
                    LOG.error(message);
                    throw new RuntimeException(message);
                }
            }
        }
    }

    public static <T> List<List<T>> splitSourceFiles(List<T> sourceList, int adviceNumber) {
        ArrayList<List<T>> splitedList = new ArrayList<List<T>>();
        int averageLength = sourceList.size() / adviceNumber;
        averageLength = averageLength == 0 ? 1 : averageLength;
        int begin = 0;
        while (begin < sourceList.size()) {
            int end = begin + averageLength;
            if (end > sourceList.size()) {
                end = sourceList.size();
            }
            splitedList.add(sourceList.subList(begin, end));
            begin = end;
        }
        return splitedList;
    }

    public static String generateFileMiddleName() {
        String randomChars = "0123456789abcdefghmnpqrstuvwxyz";
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd_HHmmss_SSS");
        return dateFormat.format(new Date()) + "_" + RandomStringUtils.random((int)8, (String)randomChars);
    }

    static {
        mFileTypes.put("504B", "zip");
        mFileTypes.put("5261", "rar");
        mFileTypes.put("1F8B", "gz");
        mFileTypes.put("1F9D", "z");
        mFileTypes.put("1FA0", "z");
        mFileTypes.put("425A", "bz2");
        mFileTypes.put("377A", "7z");
        mFileTypes.put("FD37", "xz");
        mFileTypes.put("0422", "lz4");
        mFileTypes.put("7573", "tar");
    }
}

