/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.storage.writer;

import com.wgzhao.addax.common.base.Constant;
import com.wgzhao.addax.common.compress.ZipCycleOutputStream;
import com.wgzhao.addax.common.element.BoolColumn;
import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.DateColumn;
import com.wgzhao.addax.common.element.LongColumn;
import com.wgzhao.addax.common.element.Record;
import com.wgzhao.addax.common.element.TimestampColumn;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.plugin.RecordReceiver;
import com.wgzhao.addax.common.plugin.TaskPluginCollector;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.util.Configuration;
import com.wgzhao.addax.storage.reader.StorageReaderErrorCode;
import com.wgzhao.addax.storage.util.FileHelper;
import com.wgzhao.addax.storage.writer.StorageWriterErrorCode;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.compress.compressors.CompressorException;
import org.apache.commons.compress.compressors.CompressorOutputStream;
import org.apache.commons.compress.compressors.CompressorStreamFactory;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageWriterUtil {
    private static final Logger LOG = LoggerFactory.getLogger(StorageWriterUtil.class);
    private static final Set<String> supportedWriteModes = new HashSet<String>(Arrays.asList("truncate", "append", "nonConflict", "overwrite"));

    private StorageWriterUtil() {
    }

    public static void validateParameter(Configuration writerConfiguration) {
        String fileFormat;
        String delimiterInStr;
        String writeMode = writerConfiguration.getNecessaryValue("writeMode", (ErrorCode)StorageWriterErrorCode.REQUIRED_VALUE);
        if (!supportedWriteModes.contains(writeMode = writeMode.trim())) {
            throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.ILLEGAL_VALUE, (String)String.format("The writeMode [%s] is unsupported, it only supports [%s]", writeMode, StringUtils.join(supportedWriteModes, (String)",")));
        }
        writerConfiguration.set("writeMode", (Object)writeMode);
        String encoding = writerConfiguration.getString("encoding");
        if (StringUtils.isBlank((CharSequence)encoding)) {
            LOG.warn(String.format("The item encoding is empty, uses [%s] as default.", "UTF-8"));
            writerConfiguration.set("encoding", (Object)"UTF-8");
        } else {
            try {
                encoding = encoding.trim();
                writerConfiguration.set("encoding", (Object)encoding);
                Charsets.toCharset((String)encoding);
            }
            catch (Exception e) {
                throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.ILLEGAL_VALUE, (String)String.format("The encoding [%s] is unsupported.", encoding), (Throwable)e);
            }
        }
        String compress = writerConfiguration.getString("compress");
        if (StringUtils.isBlank((CharSequence)compress)) {
            writerConfiguration.set("compress", null);
        }
        if (null != (delimiterInStr = writerConfiguration.getString("fieldDelimiter")) && 1 != delimiterInStr.length()) {
            throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.ILLEGAL_VALUE, (String)String.format("The delimiter only supports single character, [%s] is invalid.", delimiterInStr));
        }
        if (null == delimiterInStr) {
            LOG.warn(String.format("The item delimiter is empty, uses [%s] as default.", Character.valueOf(',')));
            writerConfiguration.set("fieldDelimiter", (Object)Character.valueOf(','));
        }
        if (!Constant.SUPPORTED_FILE_FORMAT.contains(fileFormat = writerConfiguration.getString("fileFormat", "text"))) {
            throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.ILLEGAL_VALUE, (String)String.format("The fileFormat [%s] you configured is invalid, it only supports %s.", fileFormat, Constant.SUPPORTED_FILE_FORMAT));
        }
    }

    public static List<Configuration> split(Configuration writerSliceConfig, Set<String> originAllFileExists, int mandatoryNumber) {
        ArrayList<Configuration> writerSplitConfigs = new ArrayList<Configuration>();
        LOG.info("Begin to split...");
        if (mandatoryNumber == 1) {
            writerSplitConfigs.add(writerSliceConfig);
            return writerSplitConfigs;
        }
        HashSet<String> allFileExists = new HashSet<String>(originAllFileExists);
        String filePrefix = writerSliceConfig.getString("fileName");
        for (int i = 0; i < mandatoryNumber; ++i) {
            Configuration splitTaskConfig = writerSliceConfig.clone();
            String fullFileName = String.format("%s__%s", filePrefix, FileHelper.generateFileMiddleName());
            while (allFileExists.contains(fullFileName)) {
                fullFileName = String.format("%s__%s", filePrefix, FileHelper.generateFileMiddleName());
            }
            allFileExists.add(fullFileName);
            splitTaskConfig.set("fileName", (Object)fullFileName);
            LOG.info(String.format("split write file name:[%s]", fullFileName));
            writerSplitConfigs.add(splitTaskConfig);
        }
        LOG.info("Finished split.");
        return writerSplitConfigs;
    }

    public static String buildFilePath(String path, String fileName, String suffix) {
        boolean isEndWithSeparator = false;
        switch (IOUtils.DIR_SEPARATOR) {
            case '/': {
                isEndWithSeparator = path.endsWith(String.valueOf(IOUtils.DIR_SEPARATOR));
                break;
            }
            case '\\': {
                isEndWithSeparator = path.endsWith(String.valueOf('\\'));
                break;
            }
        }
        if (!isEndWithSeparator) {
            path = path + IOUtils.DIR_SEPARATOR;
        }
        suffix = null == suffix ? "" : suffix.trim();
        return String.format("%s%s%s", path, fileName, suffix);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void writeToStream(RecordReceiver lineReceiver, OutputStream outputStream, Configuration config, String fileName, TaskPluginCollector taskPluginCollector) {
        String encoding = config.getString("encoding", "UTF-8");
        if (StringUtils.isBlank((CharSequence)encoding)) {
            LOG.warn("The item encoding is empty, uses [{}] as default.", (Object)"UTF-8");
            encoding = "UTF-8";
        }
        String compress = config.getString("compress");
        BufferedWriter writer = null;
        try {
            if (null == compress) {
                writer = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
            } else {
                if ("gzip".equalsIgnoreCase(compress)) {
                    compress = "gz";
                } else if ("bz2".equalsIgnoreCase(compress)) {
                    compress = "bzip2";
                }
                if ("zip".equals(compress)) {
                    ZipCycleOutputStream zis = new ZipCycleOutputStream(outputStream, fileName);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)zis, encoding));
                } else {
                    CompressorOutputStream compressorOutputStream = new CompressorStreamFactory().createCompressorOutputStream(compress, outputStream);
                    writer = new BufferedWriter(new OutputStreamWriter((OutputStream)compressorOutputStream, encoding));
                }
            }
            StorageWriterUtil.doWriteToStream(lineReceiver, writer, fileName, config, taskPluginCollector);
        }
        catch (UnsupportedEncodingException uee) {
            try {
                throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.WRITE_FILE_WITH_CHARSET_ERROR, (String)String.format("The encoding [%s] is unsupported.", encoding), (Throwable)uee);
                catch (NullPointerException e) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.RUNTIME_EXCEPTION, (String)"NPE occurred", (Throwable)e);
                }
                catch (CompressorException e) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageReaderErrorCode.ILLEGAL_VALUE, (String)("The compress algorithm [" + compress + "] is unsupported yet."));
                }
                catch (IOException e) {
                    throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.WRITE_FILE_IO_ERROR, (String)String.format("IO exception occurred when writing [%s].", fileName), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(writer, null);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Closeable)writer, null);
    }

    private static void doWriteToStream(RecordReceiver lineReceiver, BufferedWriter writer, String context, Configuration config, TaskPluginCollector taskPluginCollector) throws IOException {
        Record record;
        String fileFormat;
        CSVFormat.Builder csvBuilder = CSVFormat.DEFAULT.builder();
        csvBuilder.setRecordSeparator(IOUtils.LINE_SEPARATOR_UNIX);
        String nullFormat = config.getString("nullFormat");
        csvBuilder.setNullString(nullFormat);
        String dateFormat = config.getString("dateFormat");
        SimpleDateFormat dateParse = null;
        if (StringUtils.isNotBlank((CharSequence)dateFormat)) {
            dateParse = new SimpleDateFormat(dateFormat);
        }
        if (Objects.equals(fileFormat = config.getString("fileFormat", "text"), "sql")) {
            StorageWriterUtil.writeToSql(lineReceiver, writer, config);
            return;
        }
        String delimiterInStr = config.getString("fieldDelimiter");
        if (null != delimiterInStr && 1 != delimiterInStr.length()) {
            throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.ILLEGAL_VALUE, (String)String.format("The item delimiter is only support single character, [%s] is invalid.", delimiterInStr));
        }
        if (null == delimiterInStr) {
            LOG.warn(String.format("The item delimiter is empty, uses [%s] as default.", Character.valueOf(',')));
        }
        char fieldDelimiter = config.getChar("fieldDelimiter", ',').charValue();
        csvBuilder.setDelimiter(fieldDelimiter);
        List headers = config.getList("header", String.class);
        if (null != headers && !headers.isEmpty()) {
            csvBuilder.setHeader(headers.toArray(new String[0]));
        }
        CSVPrinter csvPrinter = new CSVPrinter((Appendable)writer, csvBuilder.build());
        while ((record = lineReceiver.getFromReader()) != null) {
            List<String> result = StorageWriterUtil.recordToList(record, nullFormat, dateParse, taskPluginCollector);
            if (result == null) continue;
            csvPrinter.printRecord(result);
        }
    }

    public static List<String> recordToList(Record record, String nullFormat, DateFormat dateParse, TaskPluginCollector taskPluginCollector) {
        try {
            ArrayList<String> splitRows = new ArrayList<String>();
            int recordLength = record.getColumnNumber();
            if (0 != recordLength) {
                for (int i = 0; i < recordLength; ++i) {
                    boolean isDateColumn;
                    Column column = record.getColumn(i);
                    if (null == column || null == column.getRawData() || column.asString().equals(nullFormat)) {
                        splitRows.add(nullFormat);
                        continue;
                    }
                    boolean bl = isDateColumn = column instanceof DateColumn || column instanceof TimestampColumn;
                    if (!isDateColumn) {
                        splitRows.add(column.asString());
                        continue;
                    }
                    if (null != dateParse) {
                        splitRows.add(dateParse.format(column.asDate()));
                        continue;
                    }
                    splitRows.add(column.asString());
                }
            }
            return splitRows;
        }
        catch (Exception e) {
            taskPluginCollector.collectDirtyRecord(record, (Throwable)e);
            return null;
        }
    }

    public static void writeToSql(RecordReceiver lineReceiver, BufferedWriter writer, Configuration config) throws IOException {
        Record record;
        String tableName = config.getNecessaryValue("table", (ErrorCode)StorageWriterErrorCode.SQL_REQUIRED_TABLE_NAME);
        String existColumns = config.getString("column", null);
        List columns = null;
        if (existColumns != null) {
            columns = config.getList("column", String.class);
        }
        boolean extendedInsert = config.getBool("extendedInsert", true);
        int batchSize = config.getInt("batchSize", 2048);
        int curNum = 0;
        String sqlHeader = "INSERT INTO " + tableName;
        if (existColumns != null) {
            sqlHeader = sqlHeader + "(" + StringUtils.join((Iterable)columns, (String)",") + ")";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(sqlHeader).append(" VALUES (");
        while ((record = lineReceiver.getFromReader()) != null) {
            if (columns != null && record.getColumnNumber() != columns.size()) {
                throw AddaxException.asAddaxException((ErrorCode)StorageWriterErrorCode.ILLEGAL_VALUE, (String)String.format("The column number [%d] of record is not equal to the column number [%d] of table.", record.getColumnNumber(), columns.size()));
            }
            for (int i = 0; i < record.getColumnNumber(); ++i) {
                Column column = record.getColumn(i);
                if (column instanceof LongColumn || column instanceof BoolColumn) {
                    sb.append(column.asString());
                } else {
                    sb.append("'").append(column.asString()).append("'");
                }
                if (i >= record.getColumnNumber() - 1) continue;
                sb.append(",");
            }
            if (extendedInsert) {
                if (curNum >= batchSize) {
                    sb.append(";\n");
                    writer.write(sb.toString());
                    sb.setLength(0);
                    sb.append(sqlHeader).append(" VALUES (");
                    curNum = 0;
                    continue;
                }
                sb.append("), (");
                ++curNum;
                continue;
            }
            sb.append(");\n");
            writer.write(sb.toString());
            sb.setLength(0);
            sb.append(sqlHeader).append(" VALUES (");
        }
        if (curNum > 0) {
            sb.delete(sb.length() - 3, sb.length()).append(";");
            writer.write(sb.toString());
        }
    }
}

