/*
 * Decompiled with CFR 0.152.
 */
package com.wgzhao.addax.plugin.writer.excelwriter;

import com.wgzhao.addax.common.element.Column;
import com.wgzhao.addax.common.element.Record;
import com.wgzhao.addax.common.exception.AddaxException;
import com.wgzhao.addax.common.plugin.RecordReceiver;
import com.wgzhao.addax.common.spi.ErrorCode;
import com.wgzhao.addax.common.spi.Writer;
import com.wgzhao.addax.common.util.Configuration;
import com.wgzhao.addax.plugin.writer.excelwriter.ExcelWriterErrorCode;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFCreationHelper;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelWriter
extends Writer {

    public static class Task
    extends Writer.Task {
        private Configuration conf;
        private String filePath;
        private List<String> header;

        public void init() {
            this.conf = this.getPluginJobConf();
            this.filePath = this.conf.get("path") + "/" + this.conf.get("fileName");
            this.header = this.conf.getList("header", String.class);
        }

        public void destroy() {
        }

        public void startWrite(RecordReceiver lineReceiver) {
            Record record;
            Cell cell;
            XSSFRow row;
            XSSFWorkbook workbook = new XSSFWorkbook();
            XSSFSheet sheet = workbook.createSheet();
            int rowNum = 0;
            if (!this.header.isEmpty()) {
                row = sheet.createRow(rowNum++);
                for (int i = 0; i < this.header.size(); ++i) {
                    cell = row.createCell(i);
                    cell.setCellValue(this.header.get(i));
                }
            }
            XSSFCellStyle dateStyle = workbook.createCellStyle();
            XSSFCreationHelper createHelper = workbook.getCreationHelper();
            dateStyle.setDataFormat(createHelper.createDataFormat().getFormat("yyyy-MM-dd HH:mm:ss"));
            while ((record = lineReceiver.getFromReader()) != null) {
                int recordLength = record.getColumnNumber();
                row = sheet.createRow(rowNum++);
                block20: for (int i = 0; i < recordLength; ++i) {
                    cell = row.createCell(i);
                    Column column = record.getColumn(i);
                    if (column == null || column.getRawData() == null) {
                        cell.setBlank();
                        continue;
                    }
                    switch (column.getType()) {
                        case INT: 
                        case LONG: {
                            cell.setCellValue((double)column.asLong().longValue());
                            continue block20;
                        }
                        case BOOL: {
                            cell.setCellValue(column.asBoolean().booleanValue());
                            continue block20;
                        }
                        case DATE: {
                            cell.setCellValue(column.asDate());
                            cell.setCellStyle((CellStyle)dateStyle);
                            continue block20;
                        }
                        case NULL: {
                            cell.setBlank();
                            continue block20;
                        }
                        default: {
                            cell.setCellValue(column.asString());
                        }
                    }
                }
            }
            try (FileOutputStream out = new FileOutputStream(this.filePath);){
                workbook.write((OutputStream)out);
                workbook.close();
            }
            catch (FileNotFoundException e) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelWriterErrorCode.WRITE_FILE_ERROR, (String)("No such file: " + this.filePath));
            }
            catch (IOException e) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelWriterErrorCode.WRITE_FILE_IO_ERROR, (String)("IOException occurred while writing to " + this.filePath));
            }
        }
    }

    public static class Job
    extends Writer.Job {
        private Configuration conf;

        public void init() {
            this.conf = this.getPluginJobConf();
            this.validateParameter();
        }

        private void validateParameter() {
            this.conf.getNecessaryValue("path", (ErrorCode)ExcelWriterErrorCode.REQUIRED_VALUE);
            String path = this.conf.getNecessaryValue("path", (ErrorCode)ExcelWriterErrorCode.REQUIRED_VALUE);
            String fileName = this.conf.getNecessaryValue("fileName", (ErrorCode)ExcelWriterErrorCode.REQUIRED_VALUE);
            if (fileName.endsWith(".xls")) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelWriterErrorCode.FILE_FORMAT_ERROR, (String)"Only support new excel format file(.xlsx)");
            }
            if (fileName.split("\\.").length == 1) {
                this.conf.set("fileName", (Object)(fileName + ".xlsx"));
            }
            try {
                boolean createdOk;
                File dir = new File(path);
                if (dir.isFile()) {
                    throw AddaxException.asAddaxException((ErrorCode)ExcelWriterErrorCode.ILLEGAL_VALUE, (String)(path + " is normal file instead of directory"));
                }
                if (!dir.exists() && !(createdOk = dir.mkdirs())) {
                    throw AddaxException.asAddaxException((ErrorCode)ExcelWriterErrorCode.CONFIG_INVALID_EXCEPTION, (String)("can not create directory '" + dir + "' failure"));
                }
            }
            catch (SecurityException se) {
                throw AddaxException.asAddaxException((ErrorCode)ExcelWriterErrorCode.SECURITY_NOT_ENOUGH, (String)("Create directory '" + path + "' failure: permission deny: "), (Throwable)se);
            }
        }

        public void prepare() {
        }

        public void destroy() {
        }

        public List<Configuration> split(int mandatoryNumber) {
            return Collections.singletonList(this.conf);
        }
    }
}

