package de.bwaldvogel.mongo.wire;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoExceptionHandler extends ChannelInboundHandlerAdapter implements ChannelHandler {

    private static final Logger log = LoggerFactory.getLogger(MongoExceptionHandler.class);

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        log.error("exception for client {}", ctx.channel().hashCode(), cause);
        ctx.channel().close();
    }
}
