/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.memory.index.Index;
import de.bwaldvogel.mongo.exception.MongoServerException;
import de.bwaldvogel.mongo.wire.message.MongoDelete;
import de.bwaldvogel.mongo.wire.message.MongoInsert;
import de.bwaldvogel.mongo.wire.message.MongoUpdate;
import org.bson.BSONObject;

public abstract class MongoCollection {
    private String collectionName;
    private String databaseName;

    protected MongoCollection(String databaseName, String collectionName) {
        this.databaseName = databaseName;
        this.collectionName = collectionName;
    }

    public String getFullName() {
        return this.databaseName + "." + this.getCollectionName();
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public abstract void addIndex(Index var1);

    public abstract void addDocument(BSONObject var1) throws MongoServerException;

    public abstract void removeDocument(BSONObject var1) throws MongoServerException;

    public abstract Iterable<BSONObject> handleQuery(BSONObject var1, int var2, int var3, BSONObject var4) throws MongoServerException;

    public abstract int handleInsert(MongoInsert var1) throws MongoServerException;

    public abstract int handleDelete(MongoDelete var1) throws MongoServerException;

    public abstract BSONObject handleDistinct(BSONObject var1) throws MongoServerException;

    public abstract BSONObject handleUpdate(MongoUpdate var1) throws MongoServerException;

    public abstract BSONObject getStats() throws MongoServerException;

    public abstract BSONObject validate() throws MongoServerException;

    public abstract BSONObject findAndModify(BSONObject var1) throws MongoServerException;

    public abstract int count(BSONObject var1) throws MongoServerException;

    public abstract int count();

    public abstract int getNumIndexes();

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.getFullName() + ")";
    }
}

