/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.regex.Pattern;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public class ValueComparator
implements Comparator<Object> {
    private static final List<Class<?>> SORT_PRIORITY = new ArrayList();

    @Override
    public int compare(Object value1, Object value2) {
        int t2;
        if (value1 == value2) {
            return 0;
        }
        int t1 = this.getTypeOrder(value1);
        if (t1 != (t2 = this.getTypeOrder(value2))) {
            return t1 < t2 ? -1 : 1;
        }
        Class<?> clazz = value1.getClass();
        if (ObjectId.class.isAssignableFrom(clazz)) {
            return ((ObjectId)value1).compareTo((ObjectId)value2);
        }
        if (Number.class.isAssignableFrom(clazz)) {
            return Double.compare(((Number)value1).doubleValue(), ((Number)value2).doubleValue());
        }
        if (String.class.isAssignableFrom(clazz)) {
            return value1.toString().compareTo(value2.toString());
        }
        if (Date.class.isAssignableFrom(clazz)) {
            Date date1 = (Date)value1;
            Date date2 = (Date)value2;
            return date1.compareTo(date2);
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            boolean b1 = (Boolean)value1;
            boolean b2 = (Boolean)value2;
            return !b1 && b2 ? -1 : (b1 && !b2 ? 1 : 0);
        }
        if (BSONObject.class.isAssignableFrom(clazz)) {
            for (String key : ((BSONObject)value1).keySet()) {
                int cmp = this.compare(((BSONObject)value1).get(key), ((BSONObject)value2).get(key));
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
        throw new UnsupportedOperationException("can't compare " + clazz);
    }

    private int getTypeOrder(Object obj) {
        if (obj == null) {
            return -1;
        }
        for (int idx = 0; idx < SORT_PRIORITY.size(); ++idx) {
            if (!SORT_PRIORITY.get(idx).isAssignableFrom(obj.getClass())) continue;
            return idx;
        }
        throw new UnsupportedOperationException("can't sort " + obj.getClass());
    }

    static {
        SORT_PRIORITY.add(Number.class);
        SORT_PRIORITY.add(String.class);
        SORT_PRIORITY.add(BSONObject.class);
        SORT_PRIORITY.add(byte[].class);
        SORT_PRIORITY.add(ObjectId.class);
        SORT_PRIORITY.add(Boolean.class);
        SORT_PRIORITY.add(Date.class);
        SORT_PRIORITY.add(Pattern.class);
    }
}

