/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.config;

import de.codecentric.boot.admin.notify.MailNotifier;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.mail.MailSenderAutoConfiguration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.mail.MailSender;

@Configuration
@ConditionalOnBean(value={MailSender.class})
@AutoConfigureAfter(value={MailSenderAutoConfiguration.class})
public class MailNotifierConfiguration {
    @Autowired
    private MailSender mailSender;

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="spring.boot.admin.notify.mail", name={"enabled"}, matchIfMissing=true)
    @ConfigurationProperties(value="spring.boot.admin.notify.mail")
    public MailNotifier mailNotifier() {
        return new MailNotifier(this.mailSender);
    }
}

