/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.discovery;

import de.codecentric.boot.admin.discovery.DefaultServiceInstanceConverter;
import de.codecentric.boot.admin.discovery.ServiceInstanceConverter;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.cloud.client.discovery.event.HeartbeatEvent;
import org.springframework.cloud.client.discovery.event.HeartbeatMonitor;
import org.springframework.cloud.client.discovery.event.InstanceRegisteredEvent;
import org.springframework.cloud.client.discovery.event.ParentHeartbeatEvent;
import org.springframework.context.event.EventListener;

public class ApplicationDiscoveryListener {
    private final DiscoveryClient discoveryClient;
    private final ApplicationRegistry registry;
    private final HeartbeatMonitor monitor = new HeartbeatMonitor();
    private ServiceInstanceConverter converter = new DefaultServiceInstanceConverter();

    public ApplicationDiscoveryListener(DiscoveryClient discoveryClient, ApplicationRegistry registry) {
        this.discoveryClient = discoveryClient;
        this.registry = registry;
    }

    @EventListener
    public void onInstanceRegistered(InstanceRegisteredEvent<?> event) {
        this.discover();
    }

    @EventListener
    public void onParentHeartbeat(ParentHeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    @EventListener
    public void onApplicationEvent(HeartbeatEvent event) {
        this.discoverIfNeeded(event.getValue());
    }

    private void discoverIfNeeded(Object value) {
        if (this.monitor.update(value)) {
            this.discover();
        }
    }

    protected void discover() {
        for (String serviceId : this.discoveryClient.getServices()) {
            for (ServiceInstance instance : this.discoveryClient.getInstances(serviceId)) {
                this.registry.register(this.convert(instance));
            }
        }
    }

    protected Application convert(ServiceInstance instance) {
        return this.converter.convert(instance);
    }

    public void setConverter(ServiceInstanceConverter converter) {
        this.converter = converter;
    }
}

